"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Repository = void 0;
var path = require("path");
var cli_error_1 = require("./cli-error");
var command_1 = require("./command");
/**
 * Allow to clone git repositories easily
 */
var Repository = /** @class */ (function () {
    /**
     * Default constructor with the given URI
     * @param uri
     */
    function Repository(uri) {
        this.uri = uri;
    }
    /**
     * Grab the repository name based on the given URI of repository.
     */
    Repository.prototype.getRepositoryName = function () {
        // check dir exists
        var regex = /(https:\/\/*git*.*\/.*\/|file:\/\/.*\/)(.*)/gm;
        var folderDirExp = regex.exec(this.uri);
        if (!folderDirExp || folderDirExp.length < 1) {
            throw new cli_error_1.CliError("Invalid repository name: " + this.uri);
        }
        return folderDirExp[2];
    };
    /**
     * Performs the clone operation
     * @param checkoutFolder the CWD / directory where to launch the clone operation
     * @param dest the destination folder of the clone
     * @param checkoutTo the optional branch/tag to use when cloning
     * @param keepHistory the optional flag to keep / omit git history
     */
    Repository.prototype.clone = function (checkoutFolder, dest, checkoutTo, keepHistory) {
        if (keepHistory === void 0) { keepHistory = true; }
        return __awaiter(this, void 0, void 0, function () {
            var commandTheiaFolder, opts, clonedDir;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        commandTheiaFolder = new command_1.Command(checkoutFolder);
                        opts = checkoutTo ? "-b " + checkoutTo : '';
                        // Use --single-branch and --depth to omit git history
                        opts += keepHistory ? '' : ' --single-branch --depth 1';
                        return [4 /*yield*/, commandTheiaFolder.exec("git clone " + opts + " " + this.uri + " " + dest)];
                    case 1:
                        _a.sent();
                        clonedDir = path.resolve(checkoutFolder, dest);
                        return [2 /*return*/, clonedDir];
                }
            });
        });
    };
    return Repository;
}());
exports.Repository = Repository;
//# sourceMappingURL=repository.js.map