"use strict";
/**********************************************************************
 * Copyright (c) 2018-2020 Red Hat, Inc.
 *
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 ***********************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cdn = void 0;
var fs = require("fs-extra");
var path = require("path");
/**
 * Generates a `cdn.json` file with the prefixes of CDN where Theia and Monaco files
 * should be retrieved from.
 *
 * @author David Festal
 */
var Cdn = /** @class */ (function () {
    function Cdn(assemblyFolder, theiaCDN, monacoCDN) {
        this.assemblyFolder = assemblyFolder;
        this.theiaCDN = theiaCDN;
        this.monacoCDN = monacoCDN;
    }
    Cdn.prototype.create = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, fs.writeFile(path.join(this.assemblyFolder, 'cdn.json'), JSON.stringify({
                            theia: this.theiaCDN,
                            monaco: this.monacoCDN,
                        }))];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    Cdn.defaultTheiaCdnPrefix = 'https://cdn.jsdelivr.net/gh/davidfestal/che-theia-cdn@latest/che-theia-editor/';
    Cdn.defaultMonacoCdnPrefix = 'https://cdn.jsdelivr.net/npm/';
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    Cdn.argBuilder = function (theYargs) {
        return theYargs
            .option('theia', {
            describe: 'Base URL of the CDN that will host Theia files',
            requiresArg: true,
            type: 'string',
            default: Cdn.defaultTheiaCdnPrefix,
            defaultDescription: Cdn.defaultTheiaCdnPrefix,
        })
            .option('monaco', {
            describe: 'Base URL of the CDN that will host Monaco Editor files',
            requiresArg: true,
            type: 'string',
            default: Cdn.defaultMonacoCdnPrefix,
            defaultDescription: Cdn.defaultMonacoCdnPrefix,
        });
    };
    return Cdn;
}());
exports.Cdn = Cdn;
//# sourceMappingURL=cdn.js.map