/// <reference types="node" />
import { ReadStream } from 'fs';
import { Logger } from './logger';
import { NexeOptions } from './options';
import { NexeTarget } from './target';
import { Bundle } from './fs/bundle';
declare type StringReplacer = (match: string) => string;
export interface NexeFile {
    filename: string;
    absPath: string;
    contents: string;
}
export { NexeOptions };
export declare class NexeError extends Error {
    constructor(m: string);
}
export declare class NexeCompiler {
    options: NexeOptions;
    /**
     * Epoch of when compilation started
     */
    private start;
    private compileStep;
    log: Logger;
    /**
     * Copy of process.env
     */
    env: {
        [x: string]: string | undefined;
    };
    /**
     * Virtual FileSystem
     */
    bundle: Bundle;
    /**
     * Root directory for the source of the current build
     */
    src: string;
    /**
     * In memory files that are being manipulated by the compiler
     */
    files: NexeFile[];
    /**
     * Standalone pieces of code run before the application entrypoint
     */
    shims: string[];
    /**
     * The last shim (defaults to "require('module').runMain()")
     */
    startup: string;
    /**
     * The main entrypoint filename for your application - eg. node mainFile.js
     */
    entrypoint: string | undefined;
    /**
     * Not used
     */
    targets: NexeTarget[];
    /**
     * Current target of the compiler
     */
    target: NexeTarget;
    /**
     * Output filename (-o myapp.exe)
     */
    output: string;
    /**
     * Flag to indicate whether or notstdin was used for input
     */
    stdinUsed: boolean;
    /**
     * Path to the configure script
     */
    configureScript: string;
    /**
     * The file path of node binary
     */
    nodeSrcBinPath: string;
    /**
     * Remote asset path if available
     */
    remoteAsset: string;
    constructor(options: NexeOptions);
    addResource(file: string, content?: Buffer | string): Promise<void>;
    readonly binaryConfiguration: {
        resources: {
            [relativeFilePath: string]: [number, number];
        };
    };
    readonly resourceSize: number;
    readFileAsync(file: string): Promise<NexeFile>;
    writeFileAsync(file: string, contents: string | Buffer): Promise<any>;
    replaceInFileAsync(file: string, replace: string | RegExp, value: string | StringReplacer): Promise<void>;
    setFileContentsAsync(file: string, contents: string): Promise<void>;
    quit(error?: any): Promise<unknown>;
    assertBuild(): void;
    getNodeExecutableLocation(target?: NexeTarget): string;
    private _runBuildCommandAsync;
    private _configureAsync;
    build(): Promise<ReadStream>;
    private _shouldCompileBinaryAsync;
    compileAsync(target: NexeTarget): Promise<NodeJS.ReadableStream>;
    code(): string;
    private _assembleDeliverable;
}
