"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var util_1 = require("../util");
function default_1(compiler, next) {
    compiler.shims.push(util_1.wrap("process.__nexe = " + JSON.stringify(compiler.binaryConfiguration) + ";\n" +
        "\"use strict\";\nObject.defineProperty(exports, \"__esModule\", { value: true });\nvar originalFsMethods = null;\nvar lazyRestoreFs = function () { };\nfunction shimFs(binary, fs) {\n    if (fs === void 0) { fs = require('fs'); }\n    if (originalFsMethods !== null) {\n        return;\n    }\n    originalFsMethods = Object.assign({}, fs);\n    var blobPath = binary.blobPath, manifest = binary.resources, _a = binary.layout, resourceStart = _a.resourceStart, stat = _a.stat, directories = {}, notAFile = '!@#$%^&*', isWin = process.platform.startsWith('win'), isString = function (x) { return typeof x === 'string' || x instanceof String; }, noop = function () { }, path = require('path'), baseDir = path.dirname(process.execPath);\n    var log = function (_) { return true; };\n    if ((process.env.DEBUG || '').toLowerCase().includes('nexe:require')) {\n        log = function (text) { return process.stderr.write('[nexe] - ' + text + '\\n'); };\n    }\n    var winPath = function (key) {\n        if (isWin && key.substr(1, 2) === ':\\\\') {\n            key = key[0].toUpperCase() + key.substr(1);\n        }\n        return key;\n    };\n    var getKey = function getKey(filepath) {\n        if (Buffer.isBuffer(filepath)) {\n            filepath = filepath.toString();\n        }\n        if (!isString(filepath)) {\n            return notAFile;\n        }\n        var key = path.resolve(baseDir, filepath);\n        return winPath(key);\n    };\n    var statTime = function () {\n        return {\n            dev: 0,\n            ino: 0,\n            nlink: 0,\n            rdev: 0,\n            uid: 123,\n            gid: 500,\n            blksize: 4096,\n            blocks: 0,\n            atime: new Date(stat.atime),\n            atimeMs: stat.atime.getTime(),\n            mtime: new Date(stat.mtime),\n            mtimeMs: stat.mtime.getTime(),\n            ctime: new Date(stat.ctime),\n            ctimMs: stat.ctime.getTime(),\n            birthtime: new Date(stat.birthtime),\n            birthtimeMs: stat.birthtime.getTime()\n        };\n    };\n    var createStat = function (extensions) {\n        return Object.assign(new fs.Stats(), binary.layout.stat, statTime(), extensions);\n    };\n    var ownStat = function (filepath) {\n        setupManifest();\n        var key = getKey(filepath);\n        if (directories[key]) {\n            var mode = binary.layout.stat.mode;\n            mode |= fs.constants.S_IFDIR;\n            mode &= ~fs.constants.S_IFREG;\n            return createStat({ mode: mode, size: 0 });\n        }\n        if (manifest[key]) {\n            return createStat({ size: manifest[key][1] });\n        }\n    };\n    function makeLong(filepath) {\n        return path._makeLong && path._makeLong(filepath);\n    }\n    function fileOpts(options) {\n        return !options ? {} : isString(options) ? { encoding: options } : options;\n    }\n    var setupManifest = function () {\n        Object.keys(manifest).forEach(function (filepath) {\n            var entry = manifest[filepath];\n            var absolutePath = getKey(filepath);\n            var longPath = makeLong(absolutePath);\n            var normalizedPath = winPath(path.normalize(filepath));\n            if (!manifest[absolutePath]) {\n                manifest[absolutePath] = entry;\n            }\n            if (longPath && !manifest[longPath]) {\n                manifest[longPath] = entry;\n            }\n            if (!manifest[normalizedPath]) {\n                manifest[normalizedPath] = manifest[filepath];\n            }\n            var currentDir = path.dirname(absolutePath);\n            var prevDir = absolutePath;\n            while (currentDir !== prevDir) {\n                directories[currentDir] = directories[currentDir] || {};\n                directories[currentDir][path.basename(prevDir)] = true;\n                var longDir = makeLong(currentDir);\n                if (longDir && !directories[longDir]) {\n                    directories[longDir] = directories[currentDir];\n                }\n                prevDir = currentDir;\n                currentDir = path.dirname(currentDir);\n            }\n        });\n        manifest[notAFile] = false;\n        directories[notAFile] = false;\n        setupManifest = noop;\n    };\n    //naive patches intended to work for most use cases\n    var nfs = {\n        existsSync: function existsSync(filepath) {\n            setupManifest();\n            var key = getKey(filepath);\n            if (manifest[key] || directories[key]) {\n                return true;\n            }\n            return originalFsMethods.existsSync.apply(fs, arguments);\n        },\n        realpath: function realpath(filepath, options, cb) {\n            setupManifest();\n            var key = getKey(filepath);\n            if (isString(filepath) && (manifest[filepath] || manifest[key])) {\n                return process.nextTick(function () { return cb(null, filepath); });\n            }\n            return originalFsMethods.realpath.call(fs, filepath, options, cb);\n        },\n        realpathSync: function realpathSync(filepath, options) {\n            setupManifest();\n            var key = getKey(filepath);\n            if (manifest[key]) {\n                return filepath;\n            }\n            return originalFsMethods.realpathSync.call(fs, filepath, options);\n        },\n        readdir: function readdir(filepath, options, callback) {\n            setupManifest();\n            var dir = directories[getKey(filepath)];\n            if (dir) {\n                if ('function' === typeof options) {\n                    callback = options;\n                    options = { encoding: 'utf8' };\n                }\n                process.nextTick(function () { return callback(null, Object.keys(dir)); });\n            }\n            else {\n                return originalFsMethods.readdir.apply(fs, arguments);\n            }\n        },\n        readdirSync: function readdirSync(filepath, options) {\n            setupManifest();\n            var dir = directories[getKey(filepath)];\n            if (dir) {\n                return Object.keys(dir);\n            }\n            return originalFsMethods.readdirSync.apply(fs, arguments);\n        },\n        readFile: function readFile(filepath, options, callback) {\n            setupManifest();\n            var entry = manifest[getKey(filepath)];\n            if (!entry) {\n                return originalFsMethods.readFile.apply(fs, arguments);\n            }\n            var offset = entry[0], length = entry[1];\n            var resourceOffset = resourceStart + offset;\n            var encoding = fileOpts(options).encoding;\n            callback = typeof options === 'function' ? options : callback;\n            originalFsMethods.open(blobPath, 'r', function (err, fd) {\n                if (err)\n                    return callback(err, null);\n                originalFsMethods.read(fd, Buffer.alloc(length), 0, length, resourceOffset, function (error, bytesRead, result) {\n                    if (error) {\n                        return originalFsMethods.close(fd, function () {\n                            callback(error, null);\n                        });\n                    }\n                    originalFsMethods.close(fd, function (err) {\n                        if (err) {\n                            return callback(err, result);\n                        }\n                        callback(err, encoding ? result.toString(encoding) : result);\n                    });\n                });\n            });\n        },\n        createReadStream: function createReadStream(filepath, options) {\n            setupManifest();\n            var entry = manifest[getKey(filepath)];\n            if (!entry) {\n                return originalFsMethods.createReadStream.apply(fs, arguments);\n            }\n            var offset = entry[0], length = entry[1];\n            var resourceOffset = resourceStart + offset;\n            var opts = fileOpts(options);\n            return originalFsMethods.createReadStream(blobPath, Object.assign({}, opts, {\n                start: resourceOffset,\n                end: resourceOffset + length - 1\n            }));\n        },\n        readFileSync: function readFileSync(filepath, options) {\n            setupManifest();\n            var entry = manifest[getKey(filepath)];\n            if (!entry) {\n                return originalFsMethods.readFileSync.apply(fs, arguments);\n            }\n            var offset = entry[0], length = entry[1];\n            var resourceOffset = resourceStart + offset;\n            var encoding = fileOpts(options).encoding;\n            var fd = originalFsMethods.openSync(process.execPath, 'r');\n            var result = Buffer.alloc(length);\n            originalFsMethods.readSync(fd, result, 0, length, resourceOffset);\n            originalFsMethods.closeSync(fd);\n            return encoding ? result.toString(encoding) : result;\n        },\n        statSync: function statSync(filepath) {\n            var stat = ownStat(filepath);\n            if (stat) {\n                return stat;\n            }\n            return originalFsMethods.statSync.apply(fs, arguments);\n        },\n        stat: function stat(filepath, callback) {\n            var stat = ownStat(filepath);\n            if (stat) {\n                process.nextTick(function () {\n                    callback(null, stat);\n                });\n            }\n            else {\n                return originalFsMethods.stat.apply(fs, arguments);\n            }\n        }\n    };\n    if (typeof fs.exists === 'function') {\n        nfs.exists = function (filepath, cb) {\n            cb = cb || noop;\n            var exists = nfs.existsSync(filepath);\n            process.nextTick(function () { return cb(exists); });\n        };\n    }\n    var patches = process.nexe.patches || {};\n    delete process.nexe;\n    patches.internalModuleReadFile = function (original) {\n        var args = [];\n        for (var _i = 1; _i < arguments.length; _i++) {\n            args[_i - 1] = arguments[_i];\n        }\n        var filepath = args[0];\n        setupManifest();\n        if (manifest[filepath]) {\n            log('read     (hit)              ' + filepath);\n            return nfs.readFileSync(filepath, 'utf-8');\n        }\n        log('read          (miss)       ' + filepath);\n        return original.call.apply(original, [this].concat(args));\n    };\n    patches.internalModuleReadJSON = patches.internalModuleReadFile;\n    patches.internalModuleStat = function (original) {\n        var args = [];\n        for (var _i = 1; _i < arguments.length; _i++) {\n            args[_i - 1] = arguments[_i];\n        }\n        setupManifest();\n        var filepath = args[0];\n        if (manifest[filepath]) {\n            log('stat     (hit)              ' + filepath + '   ' + 0);\n            return 0;\n        }\n        if (directories[filepath]) {\n            log('stat dir (hit)              ' + filepath + '   ' + 1);\n            return 1;\n        }\n        var res = original.call.apply(original, [this].concat(args));\n        if (res === 0) {\n            log('stat          (miss)        ' + filepath + '   ' + res);\n        }\n        else if (res === 1) {\n            log('stat dir      (miss)        ' + filepath + '   ' + res);\n        }\n        else {\n            log('stat                 (fail) ' + filepath + '   ' + res);\n        }\n        return res;\n    };\n    if (typeof fs.exists === 'function') {\n        nfs.exists = function (filepath, cb) {\n            cb = cb || noop;\n            var exists = nfs.existsSync(filepath);\n            if (!exists) {\n                return originalFsMethods.exists(filepath, cb);\n            }\n            process.nextTick(function () { return cb(exists); });\n        };\n    }\n    if (typeof fs.copyFile === 'function') {\n        nfs.copyFile = function (filepath, dest, flags, callback) {\n            setupManifest();\n            var entry = manifest[getKey(filepath)];\n            if (!entry) {\n                return originalFsMethods.copyFile.apply(fs, arguments);\n            }\n            if (typeof flags === 'function') {\n                callback = flags;\n                flags = 0;\n            }\n            nfs.readFile(filepath, function (err, buffer) {\n                if (err) {\n                    return callback(err);\n                }\n                originalFsMethods.writeFile(dest, buffer, function (err) {\n                    if (err) {\n                        return callback(err);\n                    }\n                    callback(null);\n                });\n            });\n        };\n        nfs.copyFileSync = function (filepath, dest) {\n            setupManifest();\n            var entry = manifest[getKey(filepath)];\n            if (!entry) {\n                return originalFsMethods.copyFileSync.apply(fs, arguments);\n            }\n            return originalFsMethods.writeFileSync(dest, nfs.readFileSync(filepath));\n        };\n    }\n    Object.assign(fs, nfs);\n    lazyRestoreFs = function () {\n        Object.keys(nfs).forEach(function (key) {\n            fs[key] = originalFsMethods[key];\n        });\n        lazyRestoreFs = function () { };\n    };\n    return true;\n}\nexports.shimFs = shimFs;\nfunction restoreFs() {\n    lazyRestoreFs();\n}\nexports.restoreFs = restoreFs;\n" +
        '\nshimFs(process.__nexe)' +
        ("\n" + (compiler.options.fs ? '' : 'restoreFs()'))
    //TODO support only restoring specific methods
    ));
    compiler.shims.push(util_1.wrap("\n    if (process.argv[1] && process.env.NODE_UNIQUE_ID) {\n      const cluster = require('cluster')\n      cluster._setupWorker()\n      delete process.env.NODE_UNIQUE_ID\n    }\n  "));
    compiler.shims.push(util_1.wrap("\n      if (!process.send) {\n        const path = require('path')\n        const entry = path.resolve(path.dirname(process.execPath)," + JSON.stringify(compiler.entrypoint) + ")\n        process.argv.splice(1,0, entry)\n      }\n    "));
    return next();
}
exports.default = default_1;
