"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var acorn_1 = require("acorn");
var file_1 = require("./file");
function isNodeAString(node) {
    return Boolean(node && (node.type === 'Literal' || node.type === 'StringLiteral'));
}
function isRequire(node) {
    return node.callee.type === 'Identifier' && node.callee.name === 'require';
}
function isImport(node) {
    return node.callee.type === 'Import';
}
function walk(node, visit) {
    if (!node || typeof node.type !== 'string' || node._visited) {
        return;
    }
    visit(node);
    node._visited = true;
    for (var childNode in node) {
        var child = node[childNode];
        if (Array.isArray(child)) {
            for (var i = 0; i < child.length; i++) {
                walk(child[i], visit);
            }
        }
        else {
            walk(child, visit);
        }
    }
}
function gatherDependencies(code) {
    var result = {
        variable: false,
        deps: {}
    }, visit = function (node) {
        if (node.type === 'CallExpression' && (isRequire(node) || isImport(node))) {
            var request = node.arguments[0];
            if (isNodeAString(request)) {
                result.deps[request.value] = null;
            }
            else {
                result.variable = true;
            }
        }
        if (node.type === 'ImportDeclaration' && isNodeAString(node.source)) {
            result.deps[node.source.value] = null;
        }
    };
    walk(acorn_1.parse(code, {
        ecmaVersion: 10,
        allowReserved: true,
        allowHashBang: true,
        allowImportExportEverywhere: true,
        allowReturnOutsideFunction: true,
        sourceType: file_1.isScript(code) ? 'script' : 'module'
    }), visit);
    return result;
}
exports.gatherDependencies = gatherDependencies;
