"use strict";
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
function normalizeOptions(args) {
    var options = {
        entries: [],
        cwd: process.cwd(),
        loadContent: true,
        expand: false,
        files: {}
    };
    args.forEach(function (x) {
        var _a;
        if (typeof x === 'string')
            return options.entries.push(x);
        if (x.cwd)
            options.cwd = x.cwd;
        if (Array.isArray(x.entries))
            (_a = options.entries).push.apply(_a, __spread(x.entries));
        if ('expand' in x)
            options.expand = Boolean(x.expand);
        if ('loadContent' in x)
            options.loadContent = Boolean(x.loadContent);
        if ('files' in x)
            Object.assign(options.files, x.files);
    });
    options.entries = Array.from(new Set(options.entries));
    if (!options.entries.length) {
        try {
            options.entries.push(require.resolve(options.cwd));
        }
        catch (e) {
            throw new Error('No entry file found');
        }
    }
    return options;
}
exports.normalizeOptions = normalizeOptions;
