"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var each_1 = require("./each");
function map(list, iterator, _a) {
    var _b = _a === void 0 ? { concurrency: null } : _a, context = _b.context, concurrency = _b.concurrency;
    var results = [];
    return each_1.each.call(this, list, function (value, i) {
        var result = iterator.call(context, value, i, list);
        results.push(result);
        return result;
    }, { concurrency: concurrency })
        .then(function () { return Promise.all(results); });
}
exports.map = map;
function mapSerial(list, iterator, _a) {
    var context = (_a === void 0 ? {} : _a).context;
    return map(list, iterator, { context: context, concurrency: 1 });
}
exports.mapSerial = mapSerial;
