"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.createFile = exports.ensureDottedRelative = exports.isNodeModule = exports.nodeModuleGlobs = exports.extraGlobs = exports.hasModuleGlobs = exports.isScript = void 0;
const path_1 = require("path");
const esmRegex = /(^\s*|[}\);\n]\s*)(import\s*(['"]|(\*\s+as\s+)?(?!type)([^"'\(\)\n; ]+)\s*from\s*['"]|\{)|export\s+\*\s+from\s+["']|export\s*(\{|default|function|class|var|const|let|async\s+function))/, moduleGlob = ['**/*', '!node_modules', '!test'];
function isScript(code) {
    return !Boolean(code.match(esmRegex));
}
exports.isScript = isScript;
function hasModuleGlobs(file) {
    return nodeModuleGlobs(file) !== moduleGlob;
}
exports.hasModuleGlobs = hasModuleGlobs;
function extraGlobs(file) {
    var _a, _b, _c, _d;
    const globs = [];
    return globs.concat(...[((_b = (_a = file.package) === null || _a === void 0 ? void 0 : _a.pkg) === null || _b === void 0 ? void 0 : _b.scripts) || []]).concat(...[((_d = (_c = file.package) === null || _c === void 0 ? void 0 : _c.pkg) === null || _d === void 0 ? void 0 : _d.assets) || []]);
}
exports.extraGlobs = extraGlobs;
function nodeModuleGlobs(file, useDefault = true) {
    var _a;
    const normalGlobs = [].concat(...(((_a = file.package) === null || _a === void 0 ? void 0 : _a.files) || []));
    if (useDefault && !normalGlobs.length) {
        return moduleGlob;
    }
    return normalGlobs;
}
exports.nodeModuleGlobs = nodeModuleGlobs;
const variableImports = false;
const notNodeModule = /^\.|^\//;
function isNodeModule(request) {
    return !notNodeModule.test(request);
}
exports.isNodeModule = isNodeModule;
function ensureDottedRelative(from, to) {
    let rel = path_1.relative(from, to);
    if (!rel.startsWith('.' + path_1.sep)) {
        rel = './' + rel;
    }
    return rel.split(path_1.sep).join('/');
}
exports.ensureDottedRelative = ensureDottedRelative;
function createFile(absPath) {
    return {
        deps: {},
        absPath,
        contents: null,
        variableImports,
    };
}
exports.createFile = createFile;
//# sourceMappingURL=data:application/json;base64,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