"use strict";
if (process.send) {
    const contexts = {}, send = process.send.bind(process);
    process.on('message', async ({ modulePath, contextName, id, method, options, args }) => {
        const ctx = contexts[contextName];
        if (modulePath && !(contextName in contexts)) {
            contexts[contextName] = require(modulePath);
            let starting = Promise.resolve();
            if ('function' === typeof contexts[contextName].initialize) {
                starting = starting.then(() => contexts[contextName].initialize(options));
            }
            starting.then((x) => {
                send({ result: x, id });
            }, (error) => {
                send({ error: error.stack, id });
            });
            return;
        }
        if (!method || !ctx) {
            send({
                error: `Error: Could not find "${method}" in "${contextName}"`,
                id,
            });
            return;
        }
        let result = null;
        let error = null;
        try {
            result = await Promise.resolve(ctx[method].call(ctx, ...args));
        }
        catch (e) {
            error = e.stack;
        }
        send({ result, error, id });
    });
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoid29ya2VyLXJ1bnRpbWUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvd29ya2VyLXJ1bnRpbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLElBQUksT0FBTyxDQUFDLElBQUksRUFBRTtJQUNoQixNQUFNLFFBQVEsR0FBUSxFQUFFLEVBQ3RCLElBQUksR0FBRyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQTtJQUVuQyxPQUFPLENBQUMsRUFBRSxDQUFDLFNBQVMsRUFBRSxLQUFLLEVBQUUsRUFBRSxVQUFVLEVBQUUsV0FBVyxFQUFFLEVBQUUsRUFBRSxNQUFNLEVBQUUsT0FBTyxFQUFFLElBQUksRUFBRSxFQUFFLEVBQUU7UUFDckYsTUFBTSxHQUFHLEdBQUcsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFBO1FBQ2pDLElBQUksVUFBVSxJQUFJLENBQUMsQ0FBQyxXQUFXLElBQUksUUFBUSxDQUFDLEVBQUU7WUFDNUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxHQUFHLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQTtZQUMzQyxJQUFJLFFBQVEsR0FBRyxPQUFPLENBQUMsT0FBTyxFQUFFLENBQUE7WUFDaEMsSUFBSSxVQUFVLEtBQUssT0FBTyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUMsVUFBVSxFQUFFO2dCQUMxRCxRQUFRLEdBQUcsUUFBUSxDQUFDLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLENBQUMsVUFBVSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUE7YUFDMUU7WUFDRCxRQUFRLENBQUMsSUFBSSxDQUNYLENBQUMsQ0FBTSxFQUFFLEVBQUU7Z0JBQ1QsSUFBSSxDQUFDLEVBQUUsTUFBTSxFQUFFLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxDQUFBO1lBQ3pCLENBQUMsRUFDRCxDQUFDLEtBQUssRUFBRSxFQUFFO2dCQUNSLElBQUksQ0FBQyxFQUFFLEtBQUssRUFBRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUE7WUFDbEMsQ0FBQyxDQUNGLENBQUE7WUFDRCxPQUFNO1NBQ1A7UUFFRCxJQUFJLENBQUMsTUFBTSxJQUFJLENBQUMsR0FBRyxFQUFFO1lBQ25CLElBQUksQ0FBQztnQkFDSCxLQUFLLEVBQUUsMEJBQTBCLE1BQU0sU0FBUyxXQUFXLEdBQUc7Z0JBQzlELEVBQUU7YUFDSCxDQUFDLENBQUE7WUFDRixPQUFNO1NBQ1A7UUFFRCxJQUFJLE1BQU0sR0FBRyxJQUFJLENBQUE7UUFDakIsSUFBSSxLQUFLLEdBQUcsSUFBSSxDQUFBO1FBRWhCLElBQUk7WUFDRixNQUFNLEdBQUcsTUFBTSxPQUFPLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxNQUFNLENBQUMsQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDLENBQUMsQ0FBQTtTQUMvRDtRQUFDLE9BQU8sQ0FBQyxFQUFFO1lBQ1YsS0FBSyxHQUFHLENBQUMsQ0FBQyxLQUFLLENBQUE7U0FDaEI7UUFDRCxJQUFJLENBQUMsRUFBRSxNQUFNLEVBQUUsS0FBSyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUE7SUFDN0IsQ0FBQyxDQUFDLENBQUE7Q0FDSCJ9