import { ParserState } from './common';
export declare const enum Errors {
    Unexpected = 0,
    StrictOctalEscape = 1,
    TemplateOctalLiteral = 2,
    InvalidPrivateName = 3,
    InvalidUnicodeEscapeSequence = 4,
    InvalidCodePoint = 5,
    InvalidHexEscapeSequence = 6,
    StrictDecimalWithLeadingZero = 7,
    StrictOctalLiteral = 8,
    ExpectedNumberInRadix = 9,
    MissingExponent = 10,
    InvalidBigInt = 11,
    IDStartAfterNumber = 12,
    InvalidEightAndNine = 13,
    UnterminatedString = 14,
    UnterminatedTemplate = 15,
    UnterminatedComment = 16,
    InvalidDynamicUnicode = 17,
    IllegalCaracter = 18,
    MissingHexDigits = 19,
    InvalidImplicitOctals = 20,
    InvalidStringLT = 21,
    InvalidEscapeIdentifier = 22,
    ExpectedToken = 23,
    CantAssignTo = 24,
    InvalidLHSAsyncArrow = 25,
    SuperNoConstructor = 26,
    InvalidSuperProperty = 27,
    UnexpectedToken = 28,
    AwaitInParameter = 29,
    YieldInParameter = 30,
    InvalidExponentationLHS = 31,
    UnterminatedRegExp = 32,
    UnexpectedTokenRegExpFlag = 33,
    DuplicateRegExpFlag = 34,
    AccessorWrongArgs = 35,
    BadSetterRestParameter = 36,
    DeclNoName = 37,
    StrictFunctionName = 38,
    RestMissingArg = 39,
    InvalidGeneratorGetter = 40,
    InvalidComputedPropName = 41,
    InvalidGetSetGenerator = 42,
    InvalidAsyncGetter = 43,
    InvalidGenMethodShorthand = 44,
    InvalidLineBreak = 45,
    InvalidArrowDestructLHS = 46,
    InvalidBindingDestruct = 47,
    InvalidAsyncArrow = 48,
    StaticPrototype = 49,
    InvalidConstructor = 50,
    DuplicateConstructor = 51,
    InvalidIncDecTarget = 52,
    InvalidIncDecNew = 53,
    InvalidAssignmentTarget = 54,
    InvalidRestTrailing = 55,
    DeclarationMissingInitializer = 56,
    ForInOfLoopInitializer = 57,
    ForInOfLoopMultiBindings = 58,
    InvalidShorthandPropInit = 59,
    DuplicateProto = 60,
    InvalidLetBoundName = 61,
    InvalidNewUnary = 62,
    IllegalUseStrict = 63,
    DisallowedLetInStrict = 64,
    IllegalContinue = 65,
    IllegalBreak = 66,
    InvalidLetBracket = 67,
    InvalidDestructuringTarget = 68,
    RestDefaultInitializer = 69,
    InvalidRestNotLast = 70,
    InvalidRestArg = 71,
    InvalidRestDefault = 72,
    StrictFunction = 73,
    SloppyFunction = 74,
    WebCompatFunction = 75,
    ClassForbiddenAsStatement = 76,
    CantAssignToInOfForLoop = 77,
    InvalidAssignmentInOfForLoop = 78,
    InvalidForAwait = 79,
    InvalidTemplateContinuation = 80,
    RestricedLetProduction = 81,
    UnexpectedLetStrictReserved = 82,
    InvalidCatchParams = 83,
    InvalidCatchParamDefault = 84,
    NoCatchOrFinally = 85,
    MultipleDefaultsInSwitch = 86,
    NewlineAfterThrow = 87,
    StrictWith = 88,
    IllegalReturn = 89,
    InvalidForLHSBinding = 90,
    InvalidNewTarget = 91,
    InvalidEscapedKeyword = 92,
    MissingPrivateName = 93,
    DisallowedInContext = 94,
    AwaitOutsideAsync = 95,
    InvalidStrictLet = 96,
    InvalidLetConstBinding = 97,
    InvalidLetClassName = 98,
    KeywordNotId = 99,
    InvalidImportExportSloppy = 100,
    UnicodeOverflow = 101,
    InvalidExportImportSource = 102,
    InvalidKeywordAsAlias = 103,
    InvalidDefaultImport = 104,
    TrailingDecorators = 105,
    GeneratorConstructor = 106,
    AwaitOrYieldIdentInModule = 107,
    HtmlCommentInWebCompat = 108,
    StrictInvalidLetInExprPos = 109,
    NotAssignableLetArgs = 110,
    ForOfLet = 111,
    InvalidInvokedBlockBodyArrow = 112,
    InvalidAccessedBlockBodyArrow = 113,
    UnexpectedStrictReserved = 114,
    StrictEvalArguments = 115,
    InvalidDecoratorSemicolon = 116,
    StrictDelete = 117,
    InvalidPatternTail = 118,
    AsyncFunctionInSingleStatementContext = 119,
    InvalidTernaryYield = 120,
    InvalidArrowPostfix = 121,
    InvalidObjLitKeyStar = 122,
    DeletePrivateField = 123,
    InvalidStaticClassFieldConstructor = 124,
    InvalidClassFieldConstructor = 125,
    InvalidClassFieldArgEval = 126,
    InvalidGeneratorFunction = 127,
    AsyncRestrictedProd = 128,
    UnexpectedCharAfterObjLit = 129,
    InvalidObjLitKey = 130,
    InvalidKeyToken = 131,
    LabelRedeclaration = 132,
    InvalidNestedStatement = 133,
    UnknownLabel = 134,
    InvalidImportTail = 135,
    ImportNotOneArg = 136,
    InvalidImportNew = 137,
    InvalidSpreadInImport = 138,
    UncompleteArrow = 139,
    DuplicateBinding = 140,
    DuplicateExportBinding = 141,
    UndeclaredExportedBinding = 142,
    UnexpectedPrivateField = 143,
    DuplicateLetConstBinding = 144,
    CantAssignToValidRHS = 145,
    ContinuousNumericSeparator = 146,
    TrailingNumericSeparator = 147,
    InvalidJSXAttributeValue = 148,
    ExpectedJSXClosingTag = 149,
    AdjacentJSXElements = 150,
    InvalidNonEmptyJSXExpr = 151,
    DuplicateIdentifier = 152,
    ShadowedCatchClause = 153,
    InvalidDotProperty = 154,
    UnclosedSpreadElement = 155,
    CatchWithoutTry = 156,
    FinallyWithoutTry = 157,
    UnCorrespondingFragmentTag = 158,
    InvalidCoalescing = 159,
    OptionalChainingNoTemplate = 160,
    OptionalChainingNoSuper = 161,
    OptionalChainingNoNew = 162,
    ImportMetaOutsideModule = 163
}
export declare const errorMessages: {
    [key: string]: string;
};
export declare class ParseError extends SyntaxError {
    loc: {
        line: ParseError['line'];
        column: ParseError['column'];
    };
    index: number;
    line: number;
    column: number;
    description: string;
    constructor(startindex: number, line: number, column: number, type: Errors, ...params: string[]);
}
export declare function report(parser: ParserState, type: Errors, ...params: string[]): never;
export declare function reportScopeError(scope: any): never;
export declare function reportMessageAt(index: number, line: number, column: number, type: Errors, ...params: string[]): never;
export declare function reportScannerError(index: number, line: number, column: number, type: Errors): never;
//# sourceMappingURL=errors.d.ts.map