"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gatherDependencies = void 0;
const meriyah_1 = require("meriyah");
const file_1 = require("./file");
function isNodeAString(node) {
    return Boolean(node && (node.type === 'Literal' || node.type === 'StringLiteral'));
}
function isRequire(node) {
    return node.callee.type === 'Identifier' && node.callee.name === 'require';
}
function isImport(node) {
    return node.callee.type === 'Import';
}
function walk(node, visit) {
    if (!node || typeof node.type !== 'string' || node._visited) {
        return;
    }
    visit(node);
    node._visited = true;
    for (const childNode in node) {
        const child = node[childNode];
        if (Array.isArray(child)) {
            for (let i = 0; i < child.length; i++) {
                walk(child[i], visit);
            }
        }
        else {
            walk(child, visit);
        }
    }
}
function gatherDependencies(code, isModule) {
    const result = {
        variable: false,
        deps: {},
    }, visit = (node) => {
        if (node.type === 'CallExpression' && (isRequire(node) || isImport(node) || node.type === 'ImportExpression')) {
            const request = node.arguments[0];
            if (isNodeAString(request)) {
                result.deps[request.value] = null;
            }
            else {
                result.variable = true;
            }
        }
        if (node.type === 'ImportDeclaration' && isNodeAString(node.source)) {
            result.deps[node.source.value] = null;
        }
    }, options = {
        globalReturn: true,
        next: true,
        module: isModule || !file_1.isScript(code),
        specDeviation: true,
    };
    walk(meriyah_1.parse(code, options), visit);
    return result;
}
exports.gatherDependencies = gatherDependencies;
//# sourceMappingURL=data:application/json;base64,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