"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loader = void 0;
const file_1 = require("./file");
const path_1 = require("path");
const worker_1 = require("./worker");
const node_builtins_1 = __importDefault(require("./node-builtins"));
const os_1 = require("os");
class Loader {
    constructor(options) {
        var _a;
        this.options = options;
        this.pool = [];
        this.ended = false;
        this.currentWorker = 0;
        const cores = ((_a = os_1.cpus()) !== null && _a !== void 0 ? _a : []).length;
        this.size = Number(process.env.RESOLVE_DEPENDENCIES_CPUS) || (cores > 2 ? cores - 1 : 1);
        this.starting = [...Array(this.size)].map((x) => new worker_1.WorkerThread({ taskConccurency: 100 }));
        this.workerOptions = { ...options, files: {} };
    }
    setup() {
        if (this.initializing) {
            return this.initializing;
        }
        this.ended = false;
        //initailize all, but only wait for the first one
        return (this.initializing = Promise.race(this.starting.map((x) => {
            return x
                .sendMessage({
                modulePath: require.resolve('./node-loader'),
                contextName: 'node-loader',
                options: this.workerOptions,
            })
                .then(() => {
                if (this.ended) {
                    x.end();
                }
                this.pool.push(x);
            });
        })).then(() => undefined));
    }
    quit() {
        this.ended = true;
        this.pool.forEach((x) => x.end());
    }
    getWorker() {
        //todo wait for workers to warm up
        const worker = this.pool[this.currentWorker++];
        if (this.currentWorker === this.pool.length) {
            this.currentWorker = 0;
        }
        return worker;
    }
    loadEntry(workingDirectory, request, files = {}, warnings = []) {
        const mainFile = file_1.ensureDottedRelative(workingDirectory, path_1.resolve(workingDirectory, request));
        return this.load(workingDirectory, mainFile, files, warnings).then((entry) => {
            return { entry, files, warnings };
        }, (e) => {
            throw e;
        });
    }
    async load(cd, request, files = {}, warnings, context) {
        var _a;
        const worker = this.getWorker();
        const options = {};
        if (context) {
            Object.assign(options, this.workerOptions, { context });
        }
        else {
            Object.assign(options, this.workerOptions);
        }
        const file = await worker.sendMessage({
            contextName: 'node-loader',
            method: 'load',
            args: [cd, request, options],
        });
        if ('warning' in file) {
            warnings.push(file.warning);
            return null;
        }
        if (files[file.absPath] !== undefined) {
            return files[file.absPath];
        }
        else {
            files[file.absPath] = file;
        }
        const packageGlobs = [];
        if (file.moduleRoot && file_1.hasModuleGlobs(file)) {
            packageGlobs.push(...file_1.nodeModuleGlobs(file, false));
        }
        if (!packageGlobs.length && file_1.hasModuleGlobs((file === null || file === void 0 ? void 0 : file.belongsTo) || {})) {
            packageGlobs.push(...file_1.nodeModuleGlobs(file.belongsTo || {}, false));
        }
        const fileDir = path_1.dirname(file.absPath);
        const ctx = {
            moduleRoot: file.moduleRoot || ((_a = file.belongsTo) === null || _a === void 0 ? void 0 : _a.moduleRoot) || undefined,
            package: file.package,
            expanded: Boolean(file.contextExpanded),
            globs: packageGlobs,
        };
        await Promise.all(Object.keys(file.deps).map((req) => {
            if (~node_builtins_1.default.indexOf(req)) {
                return (file.deps[req] = null);
            }
            return this.load(fileDir, req, files, warnings, ctx).then((dep) => {
                file.deps[req] = dep;
                if ((file.moduleRoot || file.belongsTo) && dep && !dep.moduleRoot) {
                    const owner = file.moduleRoot ? file : file.belongsTo;
                    dep.belongsTo = owner;
                }
            });
        }));
        return file;
    }
}
exports.Loader = Loader;
//# sourceMappingURL=data:application/json;base64,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