"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.xfetch = void 0;
/* eslint-disable @typescript-eslint/no-explicit-any */
var node_fetch_1 = require("node-fetch");
var https_proxy_agent_1 = require("https-proxy-agent");
var proxy_from_env_1 = require("proxy-from-env");
var fs_1 = require("fs");
var mkdirp = require("mkdirp");
var path = require("path");
var process = require("process");
var stream = require("stream");
var decompress = require("decompress");
var temp = require("temp");
var safe_1 = require("colors/safe");
var util_1 = require("util");
var mkdirpAsPromised = util_1.promisify(mkdirp);
var pipelineAsPromised = util_1.promisify(stream.pipeline);
temp.track();
function downloadPlugins(options) {
    if (options === void 0) { options = {}; }
    return __awaiter(this, void 0, void 0, function () {
        var failures, _a, packed, _b, ignoreErrors, pck, pluginsDir;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    failures = [];
                    _a = options.packed, packed = _a === void 0 ? false : _a, _b = options.ignoreErrors, ignoreErrors = _b === void 0 ? false : _b;
                    console.warn('--- downloading plugins ---');
                    pck = require(path.resolve(process.cwd(), 'package.json'));
                    pluginsDir = pck.theiaPluginsDir || 'plugins';
                    return [4 /*yield*/, mkdirpAsPromised(pluginsDir)];
                case 1:
                    _c.sent();
                    if (!pck.theiaPlugins) {
                        console.log(safe_1.red('error: missing mandatory \'theiaPlugins\' property.'));
                        return [2 /*return*/];
                    }
                    _c.label = 2;
                case 2:
                    _c.trys.push([2, , 4, 5]);
                    return [4 /*yield*/, Promise.all(Object.keys(pck.theiaPlugins).map(function (plugin) { return downloadPluginAsync(failures, plugin, pck.theiaPlugins[plugin], pluginsDir, packed); }))];
                case 3:
                    _c.sent();
                    return [3 /*break*/, 5];
                case 4:
                    temp.cleanupSync();
                    return [7 /*endfinally*/];
                case 5:
                    failures.forEach(function (e) { console.error(e); });
                    if (!ignoreErrors && failures.length > 0) {
                        throw new Error('Errors downloading some plugins. To make these errors non fatal, re-run with --ignore-errors');
                    }
                    return [2 /*return*/];
            }
        });
    });
}
exports.default = downloadPlugins;
/**
 * Downloads a plugin, will make multiple attempts before actually failing.
 *
 * @param failures reference to an array storing all failures
 * @param plugin plugin short name
 * @param pluginUrl url to download the plugin at
 * @param pluginsDir where to download the plugin in
 * @param packed whether to decompress or not
 */
function downloadPluginAsync(failures, plugin, pluginUrl, pluginsDir, packed) {
    return __awaiter(this, void 0, void 0, function () {
        var fileExt, targetPath, maxAttempts, retryDelay, attempts, lastError, response, error_1, retry, file, tempFile;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!plugin) {
                        return [2 /*return*/];
                    }
                    if (pluginUrl.endsWith('tar.gz')) {
                        fileExt = '.tar.gz';
                    }
                    else if (pluginUrl.endsWith('vsix')) {
                        fileExt = '.vsix';
                    }
                    else {
                        failures.push(safe_1.red("error: '" + plugin + "' has an unsupported file type: '" + pluginUrl + "'"));
                        return [2 /*return*/];
                    }
                    targetPath = path.join(process.cwd(), pluginsDir, "" + plugin + (packed === true ? fileExt : ''));
                    return [4 /*yield*/, isDownloaded(targetPath)];
                case 1:
                    // Skip plugins which have previously been downloaded.
                    if (_a.sent()) {
                        console.warn('- ' + plugin + ': already downloaded - skipping');
                        return [2 /*return*/];
                    }
                    maxAttempts = 5;
                    retryDelay = 2000;
                    attempts = 0;
                    _a.label = 2;
                case 2:
                    if (!(attempts < maxAttempts)) return [3 /*break*/, 10];
                    if (!(attempts > 0)) return [3 /*break*/, 4];
                    return [4 /*yield*/, new Promise(function (resolve) { return setTimeout(resolve, retryDelay); })];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    lastError = undefined;
                    _a.label = 5;
                case 5:
                    _a.trys.push([5, 7, , 8]);
                    return [4 /*yield*/, xfetch(pluginUrl)];
                case 6:
                    response = _a.sent();
                    return [3 /*break*/, 8];
                case 7:
                    error_1 = _a.sent();
                    lastError = error_1;
                    return [3 /*break*/, 9];
                case 8:
                    retry = response.status === 439 || response.status >= 500;
                    if (!retry) {
                        return [3 /*break*/, 10];
                    }
                    _a.label = 9;
                case 9:
                    attempts++;
                    return [3 /*break*/, 2];
                case 10:
                    if (lastError) {
                        failures.push(safe_1.red("x " + plugin + ": failed to download, last error:\n " + lastError));
                        return [2 /*return*/];
                    }
                    if (typeof response === 'undefined') {
                        failures.push(safe_1.red("x " + plugin + ": failed to download (unknown reason)"));
                        return [2 /*return*/];
                    }
                    if (response.status !== 200) {
                        failures.push(safe_1.red("x " + plugin + ": failed to download with: " + response.status + " " + response.statusText));
                        return [2 /*return*/];
                    }
                    if (!(fileExt === '.vsix' && packed === true)) return [3 /*break*/, 12];
                    file = fs_1.createWriteStream(targetPath);
                    return [4 /*yield*/, pipelineAsPromised(response.body, file)];
                case 11:
                    _a.sent();
                    return [3 /*break*/, 16];
                case 12: return [4 /*yield*/, mkdirpAsPromised(targetPath)];
                case 13:
                    _a.sent();
                    tempFile = temp.createWriteStream('theia-plugin-download');
                    return [4 /*yield*/, pipelineAsPromised(response.body, tempFile)];
                case 14:
                    _a.sent();
                    return [4 /*yield*/, decompress(tempFile.path, targetPath)];
                case 15:
                    _a.sent();
                    _a.label = 16;
                case 16:
                    console.warn(safe_1.green("+ " + plugin + ": downloaded successfully " + (attempts > 1 ? "(after " + attempts + " attempts)" : '')));
                    return [2 /*return*/];
            }
        });
    });
}
/**
 * Determine if the resource for the given path is already downloaded.
 * @param filePath the resource path.
 *
 * @returns `true` if the resource is already downloaded, else `false`.
 */
function isDownloaded(filePath) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, fs_1.promises.stat(filePath).then(function () { return true; }, function () { return false; })];
        });
    });
}
/**
 * Follow HTTP(S)_PROXY, ALL_PROXY and NO_PROXY environment variables.
 */
function xfetch(url, options) {
    var proxiedOptions = __assign({}, options);
    var proxy = proxy_from_env_1.getProxyForUrl(url);
    if (!proxiedOptions.agent && proxy !== '') {
        proxiedOptions.agent = new https_proxy_agent_1.HttpsProxyAgent(proxy);
    }
    return node_fetch_1.default(url, proxiedOptions);
}
exports.xfetch = xfetch;
//# sourceMappingURL=download-plugins.js.map