"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
var inversify_1 = require("@theia/core/shared/inversify");
var core_1 = require("@theia/core");
var browser_1 = require("@theia/core/lib/browser");
var console_contribution_1 = require("./console-contribution");
var console_manager_1 = require("./console-manager");
var console_keybinding_contexts_1 = require("./console-keybinding-contexts");
require("../../src/browser/style/index.css");
exports.default = new inversify_1.ContainerModule(function (bind) {
    bind(console_manager_1.ConsoleManager).toSelf().inSingletonScope();
    bind(browser_1.KeybindingContext).to(console_keybinding_contexts_1.ConsoleInputFocusContext).inSingletonScope();
    bind(browser_1.KeybindingContext).to(console_keybinding_contexts_1.ConsoleContentFocusContext).inSingletonScope();
    bind(browser_1.KeybindingContext).to(console_keybinding_contexts_1.ConsoleNavigationBackEnabled).inSingletonScope();
    bind(browser_1.KeybindingContext).to(console_keybinding_contexts_1.ConsoleNavigationForwardEnabled).inSingletonScope();
    bind(console_contribution_1.ConsoleContribution).toSelf().inSingletonScope();
    bind(browser_1.FrontendApplicationContribution).toService(console_contribution_1.ConsoleContribution);
    bind(core_1.CommandContribution).toService(console_contribution_1.ConsoleContribution);
    bind(browser_1.KeybindingContribution).toService(console_contribution_1.ConsoleContribution);
    bind(core_1.MenuContribution).toService(console_contribution_1.ConsoleContribution);
});
//# sourceMappingURL=console-frontend-module.js.map