/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Event } from '../common/event';
import { StorageService } from '../browser/storage-service';
import { Disposable } from '../common/disposable';
import { MenuModelRegistry } from '../common/menu';
import { CommandRegistry } from '../common/command';
export interface AuthenticationSessionsChangeEvent {
    added: ReadonlyArray<string>;
    removed: ReadonlyArray<string>;
    changed: ReadonlyArray<string>;
}
export interface AuthenticationSession {
    id: string;
    accessToken: string;
    account: {
        label: string;
        id: string;
    };
    scopes: ReadonlyArray<string>;
}
export interface AuthenticationProviderInformation {
    id: string;
    label: string;
}
export interface SessionRequest {
    disposables: Disposable[];
    requestingExtensionIds: string[];
}
export interface SessionRequestInfo {
    [scopes: string]: SessionRequest;
}
export interface AuthenticationProvider {
    id: string;
    supportsMultipleAccounts: boolean;
    label: string;
    hasSessions(): boolean;
    signOut(accountName: string): Promise<void>;
    getSessions(): Promise<ReadonlyArray<AuthenticationSession>>;
    updateSessionItems(event: AuthenticationSessionsChangeEvent): Promise<void>;
    login(scopes: string[]): Promise<AuthenticationSession>;
    logout(sessionId: string): Promise<void>;
}
export declare const AuthenticationService: unique symbol;
export interface AuthenticationService {
    isAuthenticationProviderRegistered(id: string): boolean;
    getProviderIds(): string[];
    registerAuthenticationProvider(id: string, provider: AuthenticationProvider): void;
    unregisterAuthenticationProvider(id: string): void;
    requestNewSession(id: string, scopes: string[], extensionId: string, extensionName: string): void;
    updateSessions(providerId: string, event: AuthenticationSessionsChangeEvent): void;
    readonly onDidRegisterAuthenticationProvider: Event<AuthenticationProviderInformation>;
    readonly onDidUnregisterAuthenticationProvider: Event<AuthenticationProviderInformation>;
    readonly onDidChangeSessions: Event<{
        providerId: string;
        label: string;
        event: AuthenticationSessionsChangeEvent;
    }>;
    getSessions(providerId: string): Promise<ReadonlyArray<AuthenticationSession>>;
    getLabel(providerId: string): string;
    supportsMultipleAccounts(providerId: string): boolean;
    login(providerId: string, scopes: string[]): Promise<AuthenticationSession>;
    logout(providerId: string, sessionId: string): Promise<void>;
    signOutOfAccount(providerId: string, accountName: string): Promise<void>;
}
export declare class AuthenticationServiceImpl implements AuthenticationService {
    private noAccountsMenuItem;
    private noAccountsCommand;
    private signInRequestItems;
    private authenticationProviders;
    private onDidRegisterAuthenticationProviderEmitter;
    readonly onDidRegisterAuthenticationProvider: Event<AuthenticationProviderInformation>;
    private onDidUnregisterAuthenticationProviderEmitter;
    readonly onDidUnregisterAuthenticationProvider: Event<AuthenticationProviderInformation>;
    private onDidChangeSessionsEmitter;
    readonly onDidChangeSessions: Event<{
        providerId: string;
        label: string;
        event: AuthenticationSessionsChangeEvent;
    }>;
    protected readonly menus: MenuModelRegistry;
    protected readonly commands: CommandRegistry;
    protected readonly storageService: StorageService;
    init(): void;
    getProviderIds(): string[];
    isAuthenticationProviderRegistered(id: string): boolean;
    private updateAccountsMenuItem;
    registerAuthenticationProvider(id: string, authenticationProvider: AuthenticationProvider): void;
    unregisterAuthenticationProvider(id: string): void;
    updateSessions(id: string, event: AuthenticationSessionsChangeEvent): Promise<void>;
    private updateNewSessionRequests;
    requestNewSession(providerId: string, scopes: string[], extensionId: string, extensionName: string): Promise<void>;
    getLabel(id: string): string;
    supportsMultipleAccounts(id: string): boolean;
    getSessions(id: string): Promise<ReadonlyArray<AuthenticationSession>>;
    login(id: string, scopes: string[]): Promise<AuthenticationSession>;
    logout(id: string, sessionId: string): Promise<void>;
    signOutOfAccount(id: string, accountName: string): Promise<void>;
}
export interface AllowedExtension {
    id: string;
    name: string;
}
export declare function readAllowedExtensions(storageService: StorageService, providerId: string, accountName: string): Promise<AllowedExtension[]>;
//# sourceMappingURL=authentication-service.d.ts.map