/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '../common/uri';
import { Disposable } from '../common/disposable';
import { CorePreferences } from './core-preferences';
import { EncodingService as EncodingService } from '../common/encoding-service';
export interface EncodingOverride {
    parent?: URI;
    extension?: string;
    scheme?: string;
    encoding: string;
}
export declare class EncodingRegistry {
    protected readonly encodingOverrides: EncodingOverride[];
    protected readonly preferences: CorePreferences;
    protected readonly encodingService: EncodingService;
    registerOverride(override: EncodingOverride): Disposable;
    getEncodingForResource(resource: URI, preferredEncoding?: string): string;
    protected getEncodingOverride(resource: URI): string | undefined;
}
//# sourceMappingURL=encoding-registry.d.ts.map