"use strict";
/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.BrowserKeyboardFrontendContribution = exports.KeyboardCommands = void 0;
var inversify_1 = require("inversify");
var os_1 = require("../../common/os");
var quick_pick_service_1 = require("../../common/quick-pick-service");
var browser_keyboard_layout_provider_1 = require("./browser-keyboard-layout-provider");
var KeyboardCommands;
(function (KeyboardCommands) {
    var KEYBOARD_CATEGORY = 'Keyboard';
    KeyboardCommands.CHOOSE_KEYBOARD_LAYOUT = {
        id: 'core.keyboard.choose',
        category: KEYBOARD_CATEGORY,
        label: 'Choose Keyboard Layout',
    };
})(KeyboardCommands = exports.KeyboardCommands || (exports.KeyboardCommands = {}));
var BrowserKeyboardFrontendContribution = /** @class */ (function () {
    function BrowserKeyboardFrontendContribution() {
    }
    BrowserKeyboardFrontendContribution.prototype.registerCommands = function (commandRegistry) {
        var _this = this;
        commandRegistry.registerCommand(KeyboardCommands.CHOOSE_KEYBOARD_LAYOUT, {
            execute: function () { return _this.chooseLayout(); }
        });
    };
    BrowserKeyboardFrontendContribution.prototype.chooseLayout = function () {
        return __awaiter(this, void 0, void 0, function () {
            var current, autodetect, pcLayouts, macLayouts, layouts, chosen;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        current = this.layoutProvider.currentLayoutData;
                        autodetect = {
                            label: 'Auto-detect',
                            description: this.layoutProvider.currentLayoutSource !== 'user-choice' ? "(current: " + current.name + ")" : undefined,
                            detail: 'Try to detect the keyboard layout from browser information and pressed keys.',
                            value: 'autodetect'
                        };
                        pcLayouts = this.layoutProvider.allLayoutData
                            .filter(function (layout) { return layout.hardware === 'pc'; })
                            .sort(function (a, b) { return compare(a.name, b.name); })
                            .map(function (layout) { return _this.toQuickPickValue(layout, current === layout); });
                        macLayouts = this.layoutProvider.allLayoutData
                            .filter(function (layout) { return layout.hardware === 'mac'; })
                            .sort(function (a, b) { return compare(a.name, b.name); })
                            .map(function (layout) { return _this.toQuickPickValue(layout, current === layout); });
                        if (os_1.isOSX) {
                            layouts = __spread([
                                autodetect,
                                { type: 'separator', label: 'Mac Keyboards' }
                            ], macLayouts, [
                                { type: 'separator', label: 'PC Keyboards' }
                            ], pcLayouts);
                        }
                        else {
                            layouts = __spread([
                                autodetect,
                                { type: 'separator', label: 'PC Keyboards' }
                            ], pcLayouts, [
                                { type: 'separator', label: 'Mac Keyboards' }
                            ], macLayouts);
                        }
                        return [4 /*yield*/, this.quickPickService.show(layouts, { placeholder: 'Choose a keyboard layout' })];
                    case 1:
                        chosen = _a.sent();
                        if (chosen) {
                            return [2 /*return*/, this.layoutProvider.setLayoutData(chosen)];
                        }
                        return [2 /*return*/];
                }
            });
        });
    };
    BrowserKeyboardFrontendContribution.prototype.toQuickPickValue = function (layout, isCurrent) {
        return {
            label: layout.name,
            description: (layout.hardware === 'mac' ? 'Mac' : 'PC') + " (" + layout.language + ")" + (isCurrent ? ' - current layout' : ''),
            value: layout
        };
    };
    __decorate([
        inversify_1.inject(browser_keyboard_layout_provider_1.BrowserKeyboardLayoutProvider),
        __metadata("design:type", browser_keyboard_layout_provider_1.BrowserKeyboardLayoutProvider)
    ], BrowserKeyboardFrontendContribution.prototype, "layoutProvider", void 0);
    __decorate([
        inversify_1.inject(quick_pick_service_1.QuickPickService),
        __metadata("design:type", Object)
    ], BrowserKeyboardFrontendContribution.prototype, "quickPickService", void 0);
    BrowserKeyboardFrontendContribution = __decorate([
        inversify_1.injectable()
    ], BrowserKeyboardFrontendContribution);
    return BrowserKeyboardFrontendContribution;
}());
exports.BrowserKeyboardFrontendContribution = BrowserKeyboardFrontendContribution;
function compare(a, b) {
    if (a < b) {
        return -1;
    }
    if (a > b) {
        return 1;
    }
    return 0;
}
//# sourceMappingURL=browser-keyboard-frontend-contribution.js.map