"use strict";
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultOpenerService = exports.open = exports.OpenerService = exports.OpenHandler = void 0;
var inversify_1 = require("inversify");
var common_1 = require("../common");
exports.OpenHandler = Symbol('OpenHandler');
exports.OpenerService = Symbol('OpenerService');
function open(openerService, uri, options) {
    return __awaiter(this, void 0, void 0, function () {
        var opener;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, openerService.getOpener(uri, options)];
                case 1:
                    opener = _a.sent();
                    return [2 /*return*/, opener.open(uri, options)];
            }
        });
    });
}
exports.open = open;
var DefaultOpenerService = /** @class */ (function () {
    function DefaultOpenerService(handlersProvider) {
        this.handlersProvider = handlersProvider;
        // Collection of open-handlers for custom-editor contributions.
        this.customEditorOpenHandlers = [];
        this.onDidChangeOpenersEmitter = new common_1.Emitter();
        this.onDidChangeOpeners = this.onDidChangeOpenersEmitter.event;
    }
    DefaultOpenerService.prototype.addHandler = function (openHandler) {
        var _this = this;
        this.customEditorOpenHandlers.push(openHandler);
        this.onDidChangeOpenersEmitter.fire();
        return common_1.Disposable.create(function () {
            _this.customEditorOpenHandlers.splice(_this.customEditorOpenHandlers.indexOf(openHandler), 1);
            _this.onDidChangeOpenersEmitter.fire();
        });
    };
    DefaultOpenerService.prototype.getOpener = function (uri, options) {
        return __awaiter(this, void 0, void 0, function () {
            var handlers;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.prioritize(uri, options)];
                    case 1:
                        handlers = _a.sent();
                        if (handlers.length >= 1) {
                            return [2 /*return*/, handlers[0]];
                        }
                        return [2 /*return*/, Promise.reject(new Error("There is no opener for " + uri + "."))];
                }
            });
        });
    };
    DefaultOpenerService.prototype.getOpeners = function (uri, options) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                return [2 /*return*/, uri ? this.prioritize(uri, options) : this.getHandlers()];
            });
        });
    };
    DefaultOpenerService.prototype.prioritize = function (uri, options) {
        return __awaiter(this, void 0, void 0, function () {
            var prioritized;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, common_1.Prioritizeable.prioritizeAll(this.getHandlers(), function (handler) { return __awaiter(_this, void 0, void 0, function () {
                            var _a;
                            return __generator(this, function (_b) {
                                switch (_b.label) {
                                    case 0:
                                        _b.trys.push([0, 2, , 3]);
                                        return [4 /*yield*/, handler.canHandle(uri, options)];
                                    case 1: return [2 /*return*/, _b.sent()];
                                    case 2:
                                        _a = _b.sent();
                                        return [2 /*return*/, 0];
                                    case 3: return [2 /*return*/];
                                }
                            });
                        }); })];
                    case 1:
                        prioritized = _a.sent();
                        return [2 /*return*/, prioritized.map(function (p) { return p.value; })];
                }
            });
        });
    };
    DefaultOpenerService.prototype.getHandlers = function () {
        return __spread(this.handlersProvider.getContributions(), this.customEditorOpenHandlers);
    };
    DefaultOpenerService = __decorate([
        inversify_1.injectable(),
        __param(0, inversify_1.inject(common_1.ContributionProvider)), __param(0, inversify_1.named(exports.OpenHandler)),
        __metadata("design:paramtypes", [Object])
    ], DefaultOpenerService);
    return DefaultOpenerService;
}());
exports.DefaultOpenerService = DefaultOpenerService;
//# sourceMappingURL=opener-service.js.map