"use strict";
/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceLanguageOverrideService = exports.getOverridePattern = exports.OVERRIDE_PROPERTY_PATTERN = exports.OverridePreferenceName = void 0;
var inversify_1 = require("inversify");
var common_1 = require("../../common");
var preference_schema_1 = require("../../common/preferences/preference-schema");
var OverridePreferenceName;
(function (OverridePreferenceName) {
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    function is(arg) {
        return !!arg && typeof arg === 'object' && 'preferenceName' in arg && 'overrideIdentifier' in arg;
    }
    OverridePreferenceName.is = is;
})(OverridePreferenceName = exports.OverridePreferenceName || (exports.OverridePreferenceName = {}));
var OVERRIDE_PROPERTY = '\\[(.*)\\]$';
exports.OVERRIDE_PROPERTY_PATTERN = new RegExp(OVERRIDE_PROPERTY);
exports.getOverridePattern = function (identifier) { return "\\[(" + identifier + ")\\]$"; };
var PreferenceLanguageOverrideService = /** @class */ (function () {
    function PreferenceLanguageOverrideService() {
        this.overrideIdentifiers = new Set();
    }
    // eslint-disable-next-line @typescript-eslint/no-explicit-any
    PreferenceLanguageOverrideService.prototype.testOverrideValue = function (name, value) {
        return preference_schema_1.PreferenceSchemaProperties.is(value) && exports.OVERRIDE_PROPERTY_PATTERN.test(name);
    };
    PreferenceLanguageOverrideService.prototype.overridePreferenceName = function (_a) {
        var preferenceName = _a.preferenceName, overrideIdentifier = _a.overrideIdentifier;
        return "[" + overrideIdentifier + "]." + preferenceName;
    };
    PreferenceLanguageOverrideService.prototype.overriddenPreferenceName = function (name) {
        var index = name.indexOf('.');
        if (index === -1) {
            return undefined;
        }
        var matches = name.substr(0, index).match(exports.OVERRIDE_PROPERTY_PATTERN);
        var overrideIdentifier = matches && matches[1];
        if (!overrideIdentifier || !this.overrideIdentifiers.has(overrideIdentifier)) {
            return undefined;
        }
        var preferenceName = name.substr(index + 1);
        return { preferenceName: preferenceName, overrideIdentifier: overrideIdentifier };
    };
    PreferenceLanguageOverrideService.prototype.computeOverridePatternPropertiesKey = function () {
        var e_1, _a;
        var param = '';
        try {
            for (var _b = __values(this.overrideIdentifiers), _c = _b.next(); !_c.done; _c = _b.next()) {
                var overrideIdentifier = _c.value;
                if (param.length) {
                    param += '|';
                }
                param += new RegExp(common_1.escapeRegExpCharacters(overrideIdentifier)).source;
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (_c && !_c.done && (_a = _b.return)) _a.call(_b);
            }
            finally { if (e_1) throw e_1.error; }
        }
        return param.length ? exports.getOverridePattern(param) : undefined;
    };
    PreferenceLanguageOverrideService.prototype.getOverridePreferenceNames = function (preferenceName) {
        var _a, _b, overrideIdentifier, e_2_1;
        var e_2, _c;
        return __generator(this, function (_d) {
            switch (_d.label) {
                case 0:
                    _d.trys.push([0, 5, 6, 7]);
                    _a = __values(this.overrideIdentifiers), _b = _a.next();
                    _d.label = 1;
                case 1:
                    if (!!_b.done) return [3 /*break*/, 4];
                    overrideIdentifier = _b.value;
                    return [4 /*yield*/, this.overridePreferenceName({ preferenceName: preferenceName, overrideIdentifier: overrideIdentifier })];
                case 2:
                    _d.sent();
                    _d.label = 3;
                case 3:
                    _b = _a.next();
                    return [3 /*break*/, 1];
                case 4: return [3 /*break*/, 7];
                case 5:
                    e_2_1 = _d.sent();
                    e_2 = { error: e_2_1 };
                    return [3 /*break*/, 7];
                case 6:
                    try {
                        if (_b && !_b.done && (_c = _a.return)) _c.call(_a);
                    }
                    finally { if (e_2) throw e_2.error; }
                    return [7 /*endfinally*/];
                case 7: return [2 /*return*/];
            }
        });
    };
    /**
     * @param overrideIdentifier
     * @returns true if the addition caused a change, i.e. if the identifier was not already present in the set of identifiers, false otherwise.
     */
    PreferenceLanguageOverrideService.prototype.addOverrideIdentifier = function (overrideIdentifier) {
        var alreadyPresent = this.overrideIdentifiers.has(overrideIdentifier);
        if (!alreadyPresent) {
            this.overrideIdentifiers.add(overrideIdentifier);
        }
        return !alreadyPresent;
    };
    /**
     * @param overrideIdentifier
     * @returns true if the deletion caused a change, i.e. if the identifier was present in the set, false otherwise.
     */
    PreferenceLanguageOverrideService.prototype.removeOverrideIdentifier = function (overrideIdentifier) {
        return this.overrideIdentifiers.delete(overrideIdentifier);
    };
    PreferenceLanguageOverrideService = __decorate([
        inversify_1.injectable()
    ], PreferenceLanguageOverrideService);
    return PreferenceLanguageOverrideService;
}());
exports.PreferenceLanguageOverrideService = PreferenceLanguageOverrideService;
//# sourceMappingURL=preference-language-override-service.js.map