"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var inversify_1 = require("inversify");
var chai_1 = require("chai");
var widget_manager_1 = require("./widget-manager");
var signaling_1 = require("@phosphor/signaling");
var logger_1 = require("../common/logger");
var mock_logger_1 = require("../common/test/mock-logger");
var common_1 = require("../common");
var TestWidgetFactory = /** @class */ (function () {
    function TestWidgetFactory() {
        this.invocations = 0;
        this.id = 'test';
    }
    TestWidgetFactory.prototype.createWidget = function (name) {
        return __awaiter(this, void 0, void 0, function () {
            var result;
            return __generator(this, function (_a) {
                this.invocations++;
                result = {};
                result.id = name;
                // eslint-disable-next-line @typescript-eslint/no-explicit-any
                result.disposed = new signaling_1.Signal(result);
                return [2 /*return*/, result];
            });
        });
    };
    return TestWidgetFactory;
}());
var widgetManager;
before(function () {
    var testContainer = new inversify_1.Container();
    var module = new inversify_1.ContainerModule(function (bind, unbind, isBound, rebind) {
        bind(logger_1.ILogger).to(mock_logger_1.MockLogger);
        common_1.bindContributionProvider(bind, widget_manager_1.WidgetFactory);
        bind(widget_manager_1.WidgetFactory).toConstantValue(new TestWidgetFactory());
        bind(widget_manager_1.WidgetManager).toSelf().inSingletonScope();
    });
    testContainer.load(module);
    widgetManager = testContainer.get(widget_manager_1.WidgetManager);
});
describe('widget-manager', function () {
    it('creates and caches widgets', function () { return __awaiter(void 0, void 0, void 0, function () {
        var wA, wB, _a, _b;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0: return [4 /*yield*/, widgetManager.getOrCreateWidget('test', 'widgetA')];
                case 1:
                    wA = _c.sent();
                    return [4 /*yield*/, widgetManager.getOrCreateWidget('test', 'widgetB')];
                case 2:
                    wB = _c.sent();
                    chai_1.expect(wA).not.equals(wB);
                    _b = (_a = chai_1.expect(wA)).equals;
                    return [4 /*yield*/, widgetManager.getOrCreateWidget('test', 'widgetA')];
                case 3:
                    _b.apply(_a, [_c.sent()]);
                    return [2 /*return*/];
            }
        });
    }); });
});
//# sourceMappingURL=widget-manager.spec.js.map