"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
var inversify_1 = require("inversify");
var ws_request_validators_1 = require("../../node/ws-request-validators");
var electron_ws_origin_validator_1 = require("./electron-ws-origin-validator");
exports.default = new inversify_1.ContainerModule(function (bind) {
    bind(electron_ws_origin_validator_1.ElectronWsOriginValidator).toSelf().inSingletonScope();
    bind(ws_request_validators_1.WsRequestValidatorContribution).toService(electron_ws_origin_validator_1.ElectronWsOriginValidator);
});
//# sourceMappingURL=electron-backend-hosting-module.js.map