/********************************************************************************
 * Copyright (C) 2019 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { Disposable, DisposableCollection } from '@theia/core/lib/common/disposable';
import { MonacoEditorZoneWidget } from '@theia/monaco/lib/browser/monaco-editor-zone-widget';
import { DebugEditor } from './debug-editor';
import { DebugExceptionInfo } from '../model/debug-thread';
export interface ShowDebugExceptionParams {
    info: DebugExceptionInfo;
    lineNumber: number;
    column: number;
}
export declare class DebugExceptionMonacoEditorZoneWidget extends MonacoEditorZoneWidget {
    protected computeContainerHeight(zoneHeight: number): {
        height: number;
        frameWidth: number;
    };
}
export declare class DebugExceptionWidget implements Disposable {
    readonly editor: DebugEditor;
    protected zone: MonacoEditorZoneWidget;
    protected readonly toDispose: DisposableCollection;
    protected init(): Promise<void>;
    dispose(): void;
    show({ info, lineNumber, column }: ShowDebugExceptionParams): void;
    hide(): void;
    protected render(info: DebugExceptionInfo, cb: () => void): void;
    protected layout(): void;
}
//# sourceMappingURL=debug-exception-widget.d.ts.map