/********************************************************************************
 * Copyright (C) 2021 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { ExternalTerminalService, ExternalTerminalConfiguration } from '../common/external-terminal';
export declare class MacExternalTerminalService implements ExternalTerminalService {
    protected osxOpener: string;
    protected defaultTerminalApp: string;
    openTerminal(configuration: ExternalTerminalConfiguration, cwd: string): Promise<void>;
    getDefaultExec(): Promise<string>;
    /**
     * Spawn the external terminal for the given options.
     * - The method spawns the terminal application based on the preferences, else uses the default value.
     * @param configuration the preference configuration.
     * @param cwd the optional current working directory to spawn from.
     */
    protected spawnTerminal(configuration: ExternalTerminalConfiguration, cwd?: string): Promise<void>;
    /**
     * Get the default terminal app on OSX.
     */
    protected getDefaultTerminalOSX(): string;
}
//# sourceMappingURL=mac-external-terminal-service.d.ts.map