/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import { ReactRenderer } from '@theia/core/lib/browser/widgets/react-renderer';
import { FileDialogTree } from './file-dialog-tree';
import * as React from '@theia/core/shared/react';
export declare const FILE_TREE_FILTERS_LIST_CLASS = "theia-FileTreeFiltersList";
/**
 * A set of file filters that are used by the dialog. Each entry is a human readable label,
 * like "TypeScript", and an array of extensions, e.g.
 * ```ts
 * {
 *  'Images': ['png', 'jpg']
 *  'TypeScript': ['ts', 'tsx']
 * }
 * ```
 */
export declare class FileDialogTreeFilters {
    [name: string]: string[];
}
export declare class FileDialogTreeFiltersRenderer extends ReactRenderer {
    readonly suppliedFilters: FileDialogTreeFilters;
    readonly fileDialogTree: FileDialogTree;
    readonly appliedFilters: FileDialogTreeFilters;
    constructor(suppliedFilters: FileDialogTreeFilters, fileDialogTree: FileDialogTree);
    protected readonly handleFilterChanged: (e: React.ChangeEvent<HTMLSelectElement>) => void;
    protected doRender(): React.ReactNode;
    protected renderLocation(value: string): React.ReactNode;
    protected onFilterChanged(e: React.ChangeEvent<HTMLSelectElement>): void;
    get locationList(): HTMLSelectElement | undefined;
}
//# sourceMappingURL=file-dialog-tree-filters-renderer.d.ts.map