/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
import { MaybePromise, SelectionService } from '@theia/core/lib/common';
import { Command, CommandContribution, CommandRegistry } from '@theia/core/lib/common/command';
import { FrontendApplicationContribution, ApplicationShell, NavigatableWidget, WidgetManager, FrontendApplication, CorePreferences } from '@theia/core/lib/browser';
import { MimeService } from '@theia/core/lib/browser/mime-service';
import { FileSystemPreferences } from './filesystem-preferences';
import { FileSelection } from './file-selection';
import { FileUploadService, FileUploadResult } from './file-upload-service';
import { FileService, UserFileOperationEvent } from './file-service';
import { FileChangesEvent } from '../common/files';
import { Deferred } from '@theia/core/lib/common/promise-util';
export declare namespace FileSystemCommands {
    const UPLOAD: Command;
}
export interface NavigatableWidgetMoveSnapshot {
    dirty?: object;
    view?: object;
}
export declare class FileSystemFrontendContribution implements FrontendApplicationContribution, CommandContribution {
    protected readonly shell: ApplicationShell;
    protected readonly widgetManager: WidgetManager;
    protected readonly mimeService: MimeService;
    protected readonly preferences: FileSystemPreferences;
    protected readonly corePreferences: CorePreferences;
    protected readonly selectionService: SelectionService;
    protected readonly uploadService: FileUploadService;
    protected readonly fileService: FileService;
    protected readonly userOperations: Map<number, Deferred<void>>;
    protected queueUserOperation(event: UserFileOperationEvent): void;
    protected resolveUserOperation(event: UserFileOperationEvent): void;
    initialize(): void;
    onStart?(app: FrontendApplication): MaybePromise<void>;
    registerCommands(commands: CommandRegistry): void;
    protected canUpload({ fileStat }: FileSelection): boolean;
    protected upload(selection: FileSelection): Promise<FileUploadResult | undefined>;
    protected pendingOperation: Promise<void>;
    protected run(operation: () => MaybePromise<void>): Promise<void>;
    protected runEach(participant: (resourceUri: URI, widget: NavigatableWidget) => Promise<void>): Promise<void>;
    protected readonly moveSnapshots: Map<string, NavigatableWidgetMoveSnapshot>;
    protected popMoveSnapshot(resourceUri: URI): NavigatableWidgetMoveSnapshot | undefined;
    protected applyMoveSnapshot(widget: NavigatableWidget, snapshot: NavigatableWidgetMoveSnapshot | undefined): void;
    protected pushMove(resourceUri: URI, widget: NavigatableWidget, event: UserFileOperationEvent): Promise<void>;
    protected revertMove(resourceUri: URI, widget: NavigatableWidget, event: UserFileOperationEvent): Promise<void>;
    protected applyMove(resourceUri: URI, widget: NavigatableWidget, event: UserFileOperationEvent): Promise<void>;
    protected createMoveToUri(resourceUri: URI, widget: NavigatableWidget, event: UserFileOperationEvent): URI | undefined;
    protected readonly deletedSuffix = " (deleted)";
    protected updateWidgets(event: FileChangesEvent): Promise<void>;
    protected updateWidget(uri: URI, widget: NavigatableWidget, event: FileChangesEvent, { dirty, toClose }: {
        dirty: Set<string>;
        toClose: Map<string, NavigatableWidget[]>;
    }): void;
    protected updateAssociations(): void;
}
//# sourceMappingURL=filesystem-frontend-contribution.d.ts.map