/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import URI from '@theia/core/lib/common/uri';
import { LocationService } from './location-service';
import { ReactRenderer } from '@theia/core/lib/browser/widgets/react-renderer';
import * as React from '@theia/core/shared/react';
import { FileService } from '../file-service';
import { DisposableCollection, Emitter } from '@theia/core/lib/common';
interface AutoSuggestDataEvent {
    parent: string;
    children: string[];
}
declare class ResolvedDirectoryCache {
    protected readonly fileService: FileService;
    protected pendingResolvedDirectories: Map<string, Promise<void>>;
    protected cachedDirectories: Map<string, string[]>;
    protected directoryResolvedEmitter: Emitter<AutoSuggestDataEvent>;
    readonly onDirectoryDidResolve: import("@theia/core").Event<AutoSuggestDataEvent>;
    constructor(fileService: FileService);
    tryResolveChildDirectories(inputAsURI: URI): string[] | undefined;
    protected createResolutionPromise(directoryToResolve: string): Promise<void>;
}
export declare class LocationListRenderer extends ReactRenderer {
    protected readonly service: LocationService;
    protected readonly fileService: FileService;
    protected directoryCache: ResolvedDirectoryCache;
    protected toDisposeOnNewCache: DisposableCollection;
    protected _drives: URI[] | undefined;
    protected _doShowTextInput: boolean;
    get doShowTextInput(): boolean;
    set doShowTextInput(doShow: boolean);
    protected lastUniqueTextInputLocation: URI | undefined;
    protected previousAutocompleteMatch: string;
    protected doAttemptAutocomplete: boolean;
    constructor(service: LocationService, fileService: FileService, host?: HTMLElement);
    render(): void;
    protected initResolveDirectoryCache(): void;
    protected doAfterRender: () => void;
    protected readonly handleLocationChanged: (e: React.ChangeEvent<HTMLSelectElement>) => void;
    protected readonly handleTextInputOnChange: (e: React.ChangeEvent<HTMLInputElement>) => void;
    protected readonly handleTextInputKeyDown: (e: React.KeyboardEvent<HTMLInputElement>) => void;
    protected readonly handleIconKeyDown: (e: React.KeyboardEvent<HTMLSpanElement>) => void;
    protected readonly handleTextInputOnBlur: () => void;
    protected readonly handleTextInputMouseDown: (e: React.MouseEvent<HTMLSpanElement>) => void;
    protected doRender(): React.ReactElement;
    protected renderInputIcon(): React.ReactNode;
    protected renderTextInput(): React.ReactNode;
    protected renderSelectInput(): React.ReactNode;
    protected toggleInputOnKeyDown(e: React.KeyboardEvent<HTMLSpanElement>): void;
    protected toggleToTextInputOnMouseDown(e: React.MouseEvent<HTMLSpanElement>): void;
    protected toggleToSelectInput(): void;
    /**
     * Collects the available locations based on the currently selected, and appends the available drives to it.
     */
    protected collectLocations(): LocationListRenderer.Location[];
    /**
     * Asynchronously loads the drives (if not yet available) and triggers a UI update on success with the new values.
     */
    protected doLoadDrives(): void;
    protected renderLocation(location: LocationListRenderer.Location): React.ReactNode;
    protected onLocationChanged(e: React.ChangeEvent<HTMLSelectElement>): void;
    protected trySetNewLocation(newLocation: URI): void;
    protected trySuggestDirectory(e: React.ChangeEvent<HTMLInputElement>): void;
    protected tryRenderFirstMatch(inputElement: HTMLInputElement, children: string[]): void;
    protected handleControlKeys(e: React.KeyboardEvent<HTMLInputElement>): void;
    get locationList(): HTMLSelectElement | undefined;
    get locationTextInput(): HTMLInputElement | undefined;
    dispose(): void;
}
export declare namespace LocationListRenderer {
    namespace Styles {
        const LOCATION_LIST_CLASS = "theia-LocationList";
        const LOCATION_INPUT_TOGGLE_CLASS = "theia-LocationInputToggle";
        const LOCATION_TEXT_INPUT_CLASS = "theia-LocationTextInput";
    }
    namespace Tooltips {
        const TOGGLE_TEXT_INPUT = "Switch to text-based input";
        const TOGGLE_SELECT_INPUT = "Switch to location list";
    }
    interface Location {
        uri: URI;
        isDrive?: boolean;
    }
}
export {};
//# sourceMappingURL=location-renderer.d.ts.map