"use strict";
/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
Object.defineProperty(exports, "__esModule", { value: true });
var assert = require("assert");
var file_uri_1 = require("@theia/core/lib/node/file-uri");
var file_change_collection_1 = require("./file-change-collection");
describe('FileChangeCollection', function () {
    assertChanges({
        changes: [1 /* ADDED */, 1 /* ADDED */],
        expected: 1 /* ADDED */
    });
    assertChanges({
        changes: [1 /* ADDED */, 0 /* UPDATED */],
        expected: 1 /* ADDED */
    });
    assertChanges({
        changes: [1 /* ADDED */, 2 /* DELETED */],
        expected: [1 /* ADDED */, 2 /* DELETED */]
    });
    assertChanges({
        changes: [0 /* UPDATED */, 1 /* ADDED */],
        expected: 0 /* UPDATED */
    });
    assertChanges({
        changes: [0 /* UPDATED */, 0 /* UPDATED */],
        expected: 0 /* UPDATED */
    });
    assertChanges({
        changes: [0 /* UPDATED */, 2 /* DELETED */],
        expected: 2 /* DELETED */
    });
    assertChanges({
        changes: [2 /* DELETED */, 1 /* ADDED */],
        expected: 0 /* UPDATED */
    });
    assertChanges({
        changes: [2 /* DELETED */, 0 /* UPDATED */],
        expected: 0 /* UPDATED */
    });
    assertChanges({
        changes: [2 /* DELETED */, 2 /* DELETED */],
        expected: 2 /* DELETED */
    });
    assertChanges({
        changes: [1 /* ADDED */, 0 /* UPDATED */, 2 /* DELETED */],
        expected: [1 /* ADDED */, 2 /* DELETED */]
    });
    assertChanges({
        changes: [1 /* ADDED */, 0 /* UPDATED */, 2 /* DELETED */, 1 /* ADDED */],
        expected: [1 /* ADDED */]
    });
    assertChanges({
        changes: [1 /* ADDED */, 0 /* UPDATED */, 2 /* DELETED */, 0 /* UPDATED */],
        expected: [1 /* ADDED */]
    });
    assertChanges({
        changes: [1 /* ADDED */, 0 /* UPDATED */, 2 /* DELETED */, 2 /* DELETED */],
        expected: [1 /* ADDED */, 2 /* DELETED */]
    });
    function assertChanges(_a) {
        var changes = _a.changes, expected = _a.expected;
        var expectedTypes = Array.isArray(expected) ? expected : [expected];
        var expectation = expectedTypes.map(function (type) { return typeAsString(type); }).join(' + ');
        it(changes.map(function (type) { return typeAsString(type); }).join(' + ') + " => " + expectation, function () {
            var e_1, _a;
            var collection = new file_change_collection_1.FileChangeCollection();
            var uri = file_uri_1.FileUri.create('/root/foo/bar.txt').toString();
            try {
                for (var changes_1 = __values(changes), changes_1_1 = changes_1.next(); !changes_1_1.done; changes_1_1 = changes_1.next()) {
                    var type = changes_1_1.value;
                    collection.push({ uri: uri, type: type });
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (changes_1_1 && !changes_1_1.done && (_a = changes_1.return)) _a.call(changes_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            var actual = collection.values().map(function (_a) {
                var type = _a.type;
                return typeAsString(type);
            }).join(' + ');
            assert.deepStrictEqual(expectation, actual);
        });
    }
    function typeAsString(type) {
        return type === 0 /* UPDATED */ ? 'UPDATED' : type === 1 /* ADDED */ ? 'ADDED' : 'DELETED';
    }
});
//# sourceMappingURL=file-change-collection.spec.js.map