/********************************************************************************
 * Copyright (C) 2017 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { FileSystemWatcherServer, WatchOptions, FileSystemWatcherClient, FileSystemWatcherService } from '../common/filesystem-watcher-protocol';
import { FileSystemWatcherServiceDispatcher } from './filesystem-watcher-dispatcher';
export declare const NSFW_WATCHER = "nsfw-watcher";
/**
 * Wraps the NSFW singleton service for each frontend.
 */
export declare class FileSystemWatcherServerClient implements FileSystemWatcherServer {
    protected static clientIdSequence: number;
    /**
     * Track allocated watcherIds to de-allocate on disposal.
     */
    protected watcherIds: Set<number>;
    /**
     * @todo make this number precisely map to one specific frontend.
     */
    protected readonly clientId: number;
    protected readonly watcherDispatcher: FileSystemWatcherServiceDispatcher;
    protected readonly watcherService: FileSystemWatcherService;
    watchFileChanges(uri: string, options?: WatchOptions): Promise<number>;
    unwatchFileChanges(watcherId: number): Promise<void>;
    setClient(client: FileSystemWatcherClient | undefined): void;
    dispose(): void;
}
//# sourceMappingURL=filesystem-watcher-client.d.ts.map