/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { FileSystemWatcherClient, FileSystemWatcherServiceClient, DidFilesChangedParams, FileSystemWatcherErrorParams } from '../common/filesystem-watcher-protocol';
/**
 * This component routes watch events to the right clients.
 */
export declare class FileSystemWatcherServiceDispatcher implements FileSystemWatcherServiceClient {
    /**
     * Mapping of `clientId` to actual clients.
     */
    protected readonly clients: Map<number, FileSystemWatcherClient>;
    onDidFilesChanged(event: DidFilesChangedParams): void;
    onError(event: FileSystemWatcherErrorParams): void;
    /**
     * Listen for events targeted at `clientId`.
     */
    registerClient(clientId: number, client: FileSystemWatcherClient): void;
    unregisterClient(clientId: number): void;
    /**
     * Only yield registered clients for the given `clientIds`.
     *
     * If clientIds is empty, will return all clients.
     */
    protected iterRegisteredClients(clientIds?: number[]): Iterable<FileSystemWatcherClient>;
}
//# sourceMappingURL=filesystem-watcher-dispatcher.d.ts.map