"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
var temp = require("temp");
var chai = require("chai");
var cp = require("child_process");
var fs = require("@theia/core/shared/fs-extra");
var assert = require("assert");
var node_1 = require("@theia/core/lib/node");
var nsfw_filesystem_service_1 = require("./nsfw-filesystem-service");
/* eslint-disable no-unused-expressions */
var expect = chai.expect;
var track = temp.track();
describe('nsfw-filesystem-watcher', function () {
    var _this = this;
    var root;
    var watcherService;
    var watcherId;
    this.timeout(10000);
    beforeEach(function () { return __awaiter(_this, void 0, void 0, function () {
        var tempPath;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    tempPath = temp.mkdirSync('node-fs-root');
                    // Sometimes tempPath will use some Windows 8.3 short name in its path. This is a problem
                    // since NSFW always returns paths with long names. We need to convert here.
                    // See: https://stackoverflow.com/a/34473971/7983255
                    if (process.platform === 'win32') {
                        tempPath = cp.execSync("powershell \"(Get-Item -LiteralPath '" + tempPath + "').FullName\"", {
                            encoding: 'utf8',
                        }).trim();
                    }
                    root = node_1.FileUri.create(fs.realpathSync(tempPath));
                    watcherService = createNsfwFileSystemWatcherService();
                    return [4 /*yield*/, watcherService.watchFileChanges(0, root.toString())];
                case 1:
                    watcherId = _a.sent();
                    return [4 /*yield*/, sleep(2000)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    }); });
    afterEach(function () { return __awaiter(_this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            track.cleanupSync();
            watcherService.dispose();
            return [2 /*return*/];
        });
    }); });
    it('Should receive file changes events from in the workspace by default.', function () {
        return __awaiter(this, void 0, void 0, function () {
            var actualUris, watcherClient, expectedUris;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        actualUris = new Set();
                        watcherClient = {
                            onDidFilesChanged: function (event) {
                                event.changes.forEach(function (c) { return actualUris.add(c.uri.toString()); });
                            },
                            onError: function () {
                            }
                        };
                        watcherService.setClient(watcherClient);
                        expectedUris = [
                            root.resolve('foo').toString(),
                            root.withPath(root.path.join('foo', 'bar')).toString(),
                            root.withPath(root.path.join('foo', 'bar', 'baz.txt')).toString()
                        ];
                        fs.mkdirSync(node_1.FileUri.fsPath(root.resolve('foo')));
                        expect(fs.statSync(node_1.FileUri.fsPath(root.resolve('foo'))).isDirectory()).to.be.true;
                        return [4 /*yield*/, sleep(2000)];
                    case 1:
                        _a.sent();
                        fs.mkdirSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar')));
                        expect(fs.statSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar'))).isDirectory()).to.be.true;
                        return [4 /*yield*/, sleep(2000)];
                    case 2:
                        _a.sent();
                        fs.writeFileSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar').resolve('baz.txt')), 'baz');
                        expect(fs.readFileSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar').resolve('baz.txt')), 'utf8')).to.be.equal('baz');
                        return [4 /*yield*/, sleep(2000)];
                    case 3:
                        _a.sent();
                        assert.deepStrictEqual(__spread(actualUris), expectedUris);
                        return [2 /*return*/];
                }
            });
        });
    });
    it('Should not receive file changes events from in the workspace by default if unwatched', function () {
        return __awaiter(this, void 0, void 0, function () {
            var actualUris, watcherClient;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        actualUris = new Set();
                        watcherClient = {
                            onDidFilesChanged: function (event) {
                                event.changes.forEach(function (c) { return actualUris.add(c.uri.toString()); });
                            },
                            onError: function () {
                            }
                        };
                        watcherService.setClient(watcherClient);
                        /* Unwatch root */
                        watcherService.unwatchFileChanges(watcherId);
                        fs.mkdirSync(node_1.FileUri.fsPath(root.resolve('foo')));
                        expect(fs.statSync(node_1.FileUri.fsPath(root.resolve('foo'))).isDirectory()).to.be.true;
                        return [4 /*yield*/, sleep(2000)];
                    case 1:
                        _a.sent();
                        fs.mkdirSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar')));
                        expect(fs.statSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar'))).isDirectory()).to.be.true;
                        return [4 /*yield*/, sleep(2000)];
                    case 2:
                        _a.sent();
                        fs.writeFileSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar').resolve('baz.txt')), 'baz');
                        expect(fs.readFileSync(node_1.FileUri.fsPath(root.resolve('foo').resolve('bar').resolve('baz.txt')), 'utf8')).to.be.equal('baz');
                        return [4 /*yield*/, sleep(2000)];
                    case 3:
                        _a.sent();
                        assert.deepStrictEqual(actualUris.size, 0);
                        return [2 /*return*/];
                }
            });
        });
    });
    function createNsfwFileSystemWatcherService() {
        return new nsfw_filesystem_service_1.NsfwFileSystemWatcherService({
            verbose: true
        });
    }
    function sleep(time) {
        return new Promise(function (resolve) { return setTimeout(resolve, time); });
    }
});
// eslint-disable-next-line @typescript-eslint/no-explicit-any
process.on('unhandledRejection', function (reason) {
    console.error('Unhandled promise rejection: ' + reason);
});
//# sourceMappingURL=nsfw-filesystem-watcher.spec.js.map