/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="node" />
import { WsRequestValidatorContribution } from '@theia/core/lib/node/ws-request-validators';
import * as http from 'http';
/**
 * Prevents explicit WebSocket connections from the mini-browser virtual host.
 */
export declare class MiniBrowserWsRequestValidator implements WsRequestValidatorContribution {
    protected miniBrowserHostRe: RegExp;
    protected serveSameOrigin: boolean;
    protected postConstruct(): void;
    allowWsUpgrade(request: http.IncomingMessage): Promise<boolean>;
}
//# sourceMappingURL=mini-browser-ws-validator.d.ts.map