/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import IdleValue = monaco.async.IdleValue;
import QuickOpenEntry = monaco.quickOpen.QuickOpenEntry;
export declare function setFileNameComparer(collator: IdleValue<{
    collator: Intl.Collator;
    collatorIsNumeric: boolean;
}>): void;
export declare function compareFileNames(one: string | null, other: string | null, caseSensitive?: boolean): number;
export declare function noIntlCompareFileNames(one: string | null, other: string | null, caseSensitive?: boolean): number;
export declare function compareAnything(one: string, other: string, lookFor: string): number;
export declare function compareByPrefix(one: string, other: string, lookFor: string): number;
/**
 * A good default sort implementation for quick open entries respecting highlight information
 * as well as associated resources.
 */
export declare function compareEntries(elementA: QuickOpenEntry, elementB: QuickOpenEntry, lookFor: string): number;
//# sourceMappingURL=monaco-comparers.d.ts.map