"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
var __spread = (this && this.__spread) || function () {
    for (var ar = [], i = 0; i < arguments.length; i++) ar = ar.concat(__read(arguments[i]));
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ThemeServiceWithDB = exports.stateToTheme = exports.deleteTheme = exports.putTheme = exports.getThemes = exports.MonacoThemeState = exports.monacoDB = void 0;
var idb = require("idb");
var disposable_1 = require("@theia/core/lib/common/disposable");
var theming_1 = require("@theia/core/lib/browser/theming");
var _monacoDB;
if ('indexedDB' in window) {
    _monacoDB = idb.openDB('theia-monaco', 1, {
        upgrade: function (db) {
            if (!db.objectStoreNames.contains('themes')) {
                db.createObjectStore('themes', { keyPath: 'id' });
            }
        }
    });
}
exports.monacoDB = _monacoDB;
var MonacoThemeState;
(function (MonacoThemeState) {
    function is(state) {
        return !!state && typeof state === 'object' && 'id' in state && 'label' in state && 'uiTheme' in state && 'data' in state;
    }
    MonacoThemeState.is = is;
})(MonacoThemeState = exports.MonacoThemeState || (exports.MonacoThemeState = {}));
function getThemes() {
    return __awaiter(this, void 0, void 0, function () {
        var db, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!exports.monacoDB) {
                        return [2 /*return*/, []];
                    }
                    return [4 /*yield*/, exports.monacoDB];
                case 1:
                    db = _a.sent();
                    return [4 /*yield*/, db.transaction('themes', 'readonly').objectStore('themes').getAll()];
                case 2:
                    result = _a.sent();
                    return [2 /*return*/, result.filter(MonacoThemeState.is)];
            }
        });
    });
}
exports.getThemes = getThemes;
function putTheme(state) {
    var toDispose = new disposable_1.DisposableCollection(disposable_1.Disposable.create(function () { }));
    doPutTheme(state, toDispose);
    return toDispose;
}
exports.putTheme = putTheme;
function doPutTheme(state, toDispose) {
    return __awaiter(this, void 0, void 0, function () {
        var db, id;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!exports.monacoDB) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, exports.monacoDB];
                case 1:
                    db = _a.sent();
                    if (toDispose.disposed) {
                        return [2 /*return*/];
                    }
                    id = state.id;
                    return [4 /*yield*/, db.transaction('themes', 'readwrite').objectStore('themes').put(state)];
                case 2:
                    _a.sent();
                    if (!toDispose.disposed) return [3 /*break*/, 4];
                    return [4 /*yield*/, deleteTheme(id)];
                case 3:
                    _a.sent();
                    return [2 /*return*/];
                case 4:
                    toDispose.push(disposable_1.Disposable.create(function () { return deleteTheme(id); }));
                    return [2 /*return*/];
            }
        });
    });
}
function deleteTheme(id) {
    return __awaiter(this, void 0, void 0, function () {
        var db;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    if (!exports.monacoDB) {
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, exports.monacoDB];
                case 1:
                    db = _a.sent();
                    return [4 /*yield*/, db.transaction('themes', 'readwrite').objectStore('themes').delete(id)];
                case 2:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.deleteTheme = deleteTheme;
function stateToTheme(state) {
    var id = state.id, label = state.label, description = state.description, uiTheme = state.uiTheme, data = state.data;
    var type = uiTheme === 'vs' ? 'light' : uiTheme === 'vs-dark' ? 'dark' : 'hc';
    var builtInTheme = uiTheme === 'vs' ? theming_1.BuiltinThemeProvider.lightCss : theming_1.BuiltinThemeProvider.darkCss;
    return {
        type: type,
        id: id,
        label: label,
        description: description,
        editorTheme: data.name,
        activate: function () {
            builtInTheme.use();
        },
        deactivate: function () {
            builtInTheme.unuse();
        }
    };
}
exports.stateToTheme = stateToTheme;
function getThemeFromDB(id) {
    return __awaiter(this, void 0, void 0, function () {
        var matchingState;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getThemes()];
                case 1:
                    matchingState = (_a.sent()).find(function (theme) { return theme.id === id; });
                    return [2 /*return*/, matchingState && stateToTheme(matchingState)];
            }
        });
    });
}
var ThemeServiceWithDB = /** @class */ (function (_super) {
    __extends(ThemeServiceWithDB, _super);
    function ThemeServiceWithDB() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ThemeServiceWithDB.get = function () {
        var global = window; // eslint-disable-line @typescript-eslint/no-explicit-any
        if (!global[theming_1.ThemeServiceSymbol]) {
            var themeService = new ThemeServiceWithDB();
            themeService.register.apply(themeService, __spread(theming_1.BuiltinThemeProvider.themes));
            themeService.startupTheme();
            global[theming_1.ThemeServiceSymbol] = themeService;
        }
        return global[theming_1.ThemeServiceSymbol];
    };
    ThemeServiceWithDB.prototype.loadUserTheme = function () {
        this.loadUserThemeWithDB();
    };
    ThemeServiceWithDB.prototype.loadUserThemeWithDB = function () {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            var themeId, theme, _c;
            return __generator(this, function (_d) {
                switch (_d.label) {
                    case 0:
                        themeId = window.localStorage.getItem('theme') || this.defaultTheme.id;
                        if (!((_a = this.themes[themeId]) !== null && _a !== void 0)) return [3 /*break*/, 1];
                        _c = _a;
                        return [3 /*break*/, 3];
                    case 1: return [4 /*yield*/, getThemeFromDB(themeId)];
                    case 2:
                        _c = _d.sent();
                        _d.label = 3;
                    case 3:
                        theme = (_b = _c) !== null && _b !== void 0 ? _b : this.defaultTheme;
                        this.setCurrentTheme(theme.id);
                        return [2 /*return*/];
                }
            });
        });
    };
    return ThemeServiceWithDB;
}(theming_1.ThemeService));
exports.ThemeServiceWithDB = ThemeServiceWithDB;
theming_1.ThemeService.get = ThemeServiceWithDB.get;
//# sourceMappingURL=monaco-indexed-db.js.map