"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
/********************************************************************************
 * Copyright (C) 2019 David Saunders and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/* eslint-disable no-unused-expressions */
var jsdom_1 = require("@theia/core/lib/browser/test/jsdom");
var disableJSDOM = jsdom_1.enableJSDOM();
var frontend_application_config_provider_1 = require("@theia/core/lib/browser/frontend-application-config-provider");
var application_props_1 = require("@theia/application-package/lib/application-props");
frontend_application_config_provider_1.FrontendApplicationConfigProvider.set(__assign({}, application_props_1.ApplicationProps.DEFAULT.frontend.config));
var chai_1 = require("chai");
var navigator_diff_1 = require("./navigator-diff");
var path = require("path");
var inversify_1 = require("@theia/core/shared/inversify");
var common_1 = require("@theia/core/lib/common");
var mock_logger_1 = require("@theia/core/lib/common/test/mock-logger");
var uri_1 = require("@theia/core/lib/common/uri");
var browser_1 = require("@theia/core/lib/browser");
var mock_opener_service_1 = require("@theia/core/lib/browser/test/mock-opener-service");
var message_service_1 = require("@theia/core/lib/common/message-service");
var message_service_protocol_1 = require("@theia/core/lib/common/message-service-protocol");
var file_uri_1 = require("@theia/core/lib/node/file-uri");
var file_service_1 = require("@theia/filesystem/lib/browser/file-service");
var disk_file_system_provider_1 = require("@theia/filesystem/lib/node/disk-file-system-provider");
disableJSDOM();
var testContainer;
beforeEach(function () {
    testContainer = new inversify_1.Container();
    var module = new inversify_1.ContainerModule(function (bind, unbind, isBound, rebind) {
        bind(common_1.ILogger).to(mock_logger_1.MockLogger).inSingletonScope();
        bind(common_1.SelectionService).toSelf().inSingletonScope();
        bind(navigator_diff_1.NavigatorDiff).toSelf().inSingletonScope();
        bind(browser_1.OpenerService).to(mock_opener_service_1.MockOpenerService);
        var fileService = new file_service_1.FileService();
        fileService['resourceForError'] = function (resource) { return resource.toString(); };
        fileService.registerProvider('file', new disk_file_system_provider_1.DiskFileSystemProvider());
        bind(file_service_1.FileService).toConstantValue(fileService);
        bind(message_service_1.MessageService).toSelf().inSingletonScope();
        bind(message_service_protocol_1.MessageClient).toSelf().inSingletonScope();
    });
    testContainer.load(module);
});
describe('NavigatorDiff', function () {
    it('should allow a valid first file to be added', function () { return __awaiter(void 0, void 0, void 0, function () {
        var diff, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    diff = testContainer.get(navigator_diff_1.NavigatorDiff);
                    testContainer.get(common_1.SelectionService).selection = [{
                            uri: new uri_1.default(file_uri_1.FileUri.create(path.resolve(__dirname, '../../test-resources/testFileA.json')).toString())
                        }];
                    return [4 /*yield*/, diff.addFirstComparisonFile()];
                case 1:
                    result = _a.sent();
                    chai_1.expect(result).to.be.true;
                    return [2 /*return*/];
            }
        });
    }); });
    it('should reject invalid file when added', function () { return __awaiter(void 0, void 0, void 0, function () {
        var diff, result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    diff = testContainer.get(navigator_diff_1.NavigatorDiff);
                    testContainer.get(common_1.SelectionService).selection = [{
                            uri: new uri_1.default(file_uri_1.FileUri.create(path.resolve(__dirname, '../../test-resources/nonExistentFile.json')).toString())
                        }];
                    return [4 /*yield*/, diff.addFirstComparisonFile()];
                case 1:
                    result = _a.sent();
                    chai_1.expect(result).to.be.false;
                    return [2 /*return*/];
            }
        });
    }); });
    it('should run comparison when second file is added', function (done) {
        var diff = testContainer.get(navigator_diff_1.NavigatorDiff);
        testContainer.get(common_1.SelectionService).selection = [{
                uri: new uri_1.default(file_uri_1.FileUri.create(path.resolve(__dirname, '../../test-resources/testFileA.json')).toString())
            }];
        diff.addFirstComparisonFile()
            .then(function (result) {
            testContainer.get(common_1.SelectionService).selection = [{
                    uri: new uri_1.default(file_uri_1.FileUri.create(path.resolve(__dirname, '../../test-resources/testFileB.json')).toString())
                }];
            diff.compareFiles()
                .then(function (compareResult) {
                chai_1.expect(compareResult).to.be.true;
                done();
            });
        });
    });
    it('should fail to run comparison if first file not added', function (done) {
        var diff = testContainer.get(navigator_diff_1.NavigatorDiff);
        testContainer.get(common_1.SelectionService).selection = [{
                uri: new uri_1.default(file_uri_1.FileUri.create(path.resolve(__dirname, '../../test-resources/testFileA.json')).toString())
            }];
        diff.compareFiles()
            .then(function (compareResult) {
            chai_1.expect(compareResult).to.be.false;
            done();
        });
    });
});
//# sourceMappingURL=navigator-diff.spec.js.map