/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import URI from '@theia/core/lib/common/uri';
import { Event, Resource, ResourceReadOptions, DisposableCollection, Emitter } from '@theia/core/lib/common';
import { Deferred } from '@theia/core/lib/common/promise-util';
import { MonacoEditorModel } from '@theia/monaco/lib/browser/monaco-editor-model';
import { IReference } from '@theia/monaco/lib/browser/monaco-text-model-service';
export declare class OutputResource implements Resource {
    readonly uri: URI;
    readonly editorModelRef: Deferred<IReference<MonacoEditorModel>>;
    protected _textModel: monaco.editor.ITextModel | undefined;
    protected onDidChangeContentsEmitter: Emitter<void>;
    protected toDispose: DisposableCollection;
    constructor(uri: URI, editorModelRef: Deferred<IReference<MonacoEditorModel>>);
    get textModel(): monaco.editor.ITextModel | undefined;
    get onDidChangeContents(): Event<void>;
    readContents(options?: ResourceReadOptions): Promise<string>;
    dispose(): void;
}
//# sourceMappingURL=output-resource.d.ts.map