/********************************************************************************
 * Copyright (C) 2018 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="@theia/monaco-editor-core/monaco" />
import * as PQueue from 'p-queue';
import URI from '@theia/core/lib/common/uri';
import { Deferred } from '@theia/core/lib/common/promise-util';
import { Resource, ResourceResolver } from '@theia/core/lib/common/resource';
import { Emitter, Event, Disposable, DisposableCollection } from '@theia/core';
import { MonacoEditorModel } from '@theia/monaco/lib/browser/monaco-editor-model';
import { MonacoTextModelService, IReference } from '@theia/monaco/lib/browser/monaco-text-model-service';
import { OutputResource } from '../browser/output-resource';
import { OutputPreferences } from './output-preferences';
export declare class OutputChannelManager implements Disposable, ResourceResolver {
    protected readonly textModelService: MonacoTextModelService;
    protected readonly preferences: OutputPreferences;
    protected readonly channels: Map<string, OutputChannel>;
    protected readonly resources: Map<string, OutputResource>;
    protected _selectedChannel: OutputChannel | undefined;
    protected readonly channelAddedEmitter: Emitter<{
        name: string;
    }>;
    protected readonly channelDeletedEmitter: Emitter<{
        name: string;
    }>;
    protected readonly channelWasShownEmitter: Emitter<{
        name: string;
        preserveFocus?: boolean | undefined;
    }>;
    protected readonly channelWasHiddenEmitter: Emitter<{
        name: string;
    }>;
    protected readonly selectedChannelChangedEmitter: Emitter<{
        name: string;
    } | undefined>;
    readonly onChannelAdded: Event<{
        name: string;
    }>;
    readonly onChannelDeleted: Event<{
        name: string;
    }>;
    readonly onChannelWasShown: Event<{
        name: string;
        preserveFocus?: boolean | undefined;
    }>;
    readonly onChannelWasHidden: Event<{
        name: string;
    }>;
    readonly onSelectedChannelChanged: Event<{
        name: string;
    } | undefined>;
    protected readonly toDispose: DisposableCollection;
    protected readonly toDisposeOnChannelDeletion: Map<string, Disposable>;
    getChannel(name: string): OutputChannel;
    protected registerListeners(channel: OutputChannel): Disposable;
    deleteChannel(name: string): void;
    getChannels(): OutputChannel[];
    getVisibleChannels(): OutputChannel[];
    protected get channelComparator(): (left: OutputChannel, right: OutputChannel) => number;
    dispose(): void;
    get selectedChannel(): OutputChannel | undefined;
    set selectedChannel(channel: OutputChannel | undefined);
    /**
     * Non-API: do not call directly.
     */
    resolve(uri: URI): Promise<Resource>;
    protected createResource({ uri, editorModelRef }: {
        uri: URI;
        editorModelRef: Deferred<IReference<MonacoEditorModel>>;
    }): OutputResource;
    protected createChannel(resource: OutputResource): OutputChannel;
}
export declare enum OutputChannelSeverity {
    Error = 1,
    Warning = 2,
    Info = 3
}
export declare class OutputChannel implements Disposable {
    protected readonly resource: OutputResource;
    protected readonly preferences: OutputPreferences;
    protected readonly contentChangeEmitter: Emitter<void>;
    protected readonly visibilityChangeEmitter: Emitter<{
        isVisible: boolean;
        preserveFocus?: boolean | undefined;
    }>;
    protected readonly disposedEmitter: Emitter<void>;
    protected readonly textModifyQueue: PQueue<PQueue.DefaultAddOptions>;
    protected readonly toDispose: DisposableCollection;
    protected disposed: boolean;
    protected visible: boolean;
    protected _maxLineNumber: number;
    protected decorationIds: Set<string>;
    readonly onVisibilityChange: Event<{
        isVisible: boolean;
        preserveFocus?: boolean;
    }>;
    readonly onContentChange: Event<void>;
    readonly onDisposed: Event<void>;
    constructor(resource: OutputResource, preferences: OutputPreferences);
    get name(): string;
    get uri(): URI;
    hide(): void;
    /**
     * If `preserveFocus` is `true`, the channel will not take focus. It is `false` by default.
     *  - Calling `show` without args or with `preserveFocus: false` will reveal **and** activate the `Output` widget.
     *  - Calling `show` with `preserveFocus: true` will reveal the `Output` widget but **won't** activate it.
     */
    show({ preserveFocus }?: {
        preserveFocus: boolean;
    }): void;
    /**
     * @deprecated use `show` and `hide` instead.
     */
    setVisibility(visible: boolean, options?: {
        preserveFocus: boolean;
    }): void;
    /**
     * Note: if `false` it does not meant it is disposed or not available, it is only hidden from the UI.
     */
    get isVisible(): boolean;
    clear(): void;
    dispose(): void;
    append(content: string, severity?: OutputChannelSeverity): void;
    appendLine(content: string, severity?: OutputChannelSeverity): void;
    protected doAppend({ content, severity, appendEol }: {
        content: string;
        severity: OutputChannelSeverity;
        appendEol?: boolean;
    }): Promise<void>;
    protected ensureMaxChannelHistory(textModel: monaco.editor.ITextModel): void;
    protected get maxLineNumber(): number;
    protected set maxLineNumber(maxLineNumber: number);
}
//# sourceMappingURL=output-channel.d.ts.map