"use strict";
/********************************************************************************
 * Copyright (C) 2020 TypeFox and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
var chai_1 = require("chai");
var output_uri_1 = require("./output-uri");
var assert_1 = require("assert");
describe('output-uri', function () {
    it('should fail when output channel name is an empty string', function () {
        try {
            output_uri_1.OutputUri.create('');
            assert_1.fail('Expected failure.');
        }
        catch (e) {
            chai_1.expect(e.message).to.be.equal("'name' must be defined.");
        }
    });
    it('should fail when output channel name contains whitespace only', function () {
        try {
            output_uri_1.OutputUri.create('  \t');
            assert_1.fail('Expected failure.');
        }
        catch (e) {
            chai_1.expect(e.message).to.be.equal("'name' must contain at least one non-whitespace character.");
        }
    });
    it('should handle whitespace', function () {
        var uri = output_uri_1.OutputUri.create('foo bar');
        var name = output_uri_1.OutputUri.channelName(uri);
        chai_1.expect(name).to.be.equal('foo bar');
    });
    it('should handle special characters (:) gracefully', function () {
        var uri = output_uri_1.OutputUri.create('foo: bar');
        var name = output_uri_1.OutputUri.channelName(uri);
        chai_1.expect(name).to.be.equal('foo: bar');
    });
});
//# sourceMappingURL=output-uri.spec.js.map