/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CustomEditor } from '../../../common';
import { Disposable } from '@theia/core/lib/common/disposable';
import { CommandRegistry, MenuModelRegistry } from '@theia/core';
import { SelectionService } from '@theia/core/lib/common';
import { ApplicationShell, DefaultOpenerService, WidgetManager } from '@theia/core/lib/browser';
import { CustomEditorWidget } from './custom-editor-widget';
export declare class PluginCustomEditorRegistry {
    private readonly editors;
    private readonly pendingEditors;
    private readonly resolvers;
    private readonly onWillOpenCustomEditorEmitter;
    readonly onWillOpenCustomEditor: import("@theia/core").Event<string>;
    protected readonly defaultOpenerService: DefaultOpenerService;
    protected readonly menuModelRegistry: MenuModelRegistry;
    protected readonly commandRegistry: CommandRegistry;
    protected readonly selectionService: SelectionService;
    protected readonly widgetManager: WidgetManager;
    protected readonly shell: ApplicationShell;
    protected init(): void;
    registerCustomEditor(editor: CustomEditor): Disposable;
    resolveWidget: (widget: CustomEditorWidget) => void;
    registerResolver(viewType: string, resolver: (widget: CustomEditorWidget) => void): Disposable;
}
//# sourceMappingURL=plugin-custom-editor-registry.d.ts.map