/********************************************************************************
 * Copyright (c) 2021 SAP SE or an SAP affiliate company and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import URI from '@theia/core/lib/common/uri';
export declare class UndoRedoService {
    private readonly editStacks;
    pushElement(resource: URI, undo: () => Promise<void>, redo: () => Promise<void>): void;
    removeElements(resource: URI): void;
    undo(resource: URI): void;
    redo(resource: URI): void;
}
interface StackElement {
    undo(): Promise<void> | void;
    redo(): Promise<void> | void;
}
export declare class ResourceEditStack {
    private past;
    private future;
    constructor();
    pushElement(element: StackElement): void;
    getClosestPastElement(): StackElement | null;
    getClosestFutureElement(): StackElement | null;
    moveBackward(element: StackElement): void;
    moveForward(element: StackElement): void;
}
export {};
//# sourceMappingURL=undo-redo-service.d.ts.map