"use strict";
/********************************************************************************
 * Copyright (C) 2020 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
var preference_registry_1 = require("./preference-registry");
var chai = require("chai");
var expect = chai.expect;
/* eslint-disable @typescript-eslint/no-explicit-any */
describe('PreferenceRegistryExtImpl:', function () {
    var preferenceRegistryExtImpl;
    var getProxy = function (proxyId) { };
    var set = function (identifier, instance) { };
    var dispose = function () { };
    var mockRPC = {
        getProxy: getProxy,
        set: set,
        dispose: dispose
    };
    var mockWorkspace = {};
    beforeEach(function () {
        preferenceRegistryExtImpl = new preference_registry_1.PreferenceRegistryExtImpl(mockRPC, mockWorkspace);
    });
    it('Check parseConfigurationData', function () {
        var value = {
            'my.key1.foo': 'value1',
            'my.key1.bar': 'value2',
        };
        var result = preferenceRegistryExtImpl.parseConfigurationData(value);
        expect(result.my).to.be.an('object');
        expect(result.my.key1).to.be.an('object');
        expect(result.my.key1.foo).to.be.an('string');
        expect(result.my.key1.foo).to.equal('value1');
        expect(result.my.key1.bar).to.be.an('string');
        expect(result.my.key1.bar).to.equal('value2');
    });
    it('Prototype pollution check', function () {
        var value = {
            'my.key1.foo': 'value1',
            '__proto__.injectedParsedPrototype': true,
            'a.__proto__.injectedParsedPrototype': true,
            '__proto__': {},
        };
        var result = preferenceRegistryExtImpl.parseConfigurationData(value);
        expect(result.my).to.be.an('object');
        expect(result.__proto__).to.be.an('undefined');
        expect(result.my.key1.foo).to.equal('value1');
        var prototypeObject = Object.prototype;
        expect(prototypeObject.injectedParsedPrototype).to.be.an('undefined');
        var rawObject = {};
        expect(rawObject.injectedParsedPrototype).to.be.an('undefined');
    });
    it('Prototype constructor pollution check', function () {
        var value = {
            'my.key1.foo': 'value1',
            'a.constructor.prototype.injectedParsedConstructorPrototype': true,
            'constructor.prototype.injectedParsedConstructorPrototype': true,
        };
        var result = preferenceRegistryExtImpl.parseConfigurationData(value);
        expect(result.my).to.be.an('object');
        expect(result.__proto__).to.be.an('undefined');
        expect(result.my.key1.foo).to.equal('value1');
        var prototypeObject = Object.prototype;
        expect(prototypeObject.injectedParsedConstructorPrototype).to.be.an('undefined');
        var rawObject = {};
        expect(rawObject.injectedParsedConstructorPrototype).to.be.an('undefined');
    });
});
//# sourceMappingURL=preference-registry.spec.js.map