/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { TreeModelImpl, TreeWidget, CompositeTreeNode, TreeNode, PreferenceSchemaProvider, PreferenceDataProperty, NodeProps, ExpandableTreeNode } from '@theia/core/lib/browser';
import { Emitter } from '@theia/core';
import { PreferencesSearchbarWidget } from './views/preference-searchbar-widget';
import { PreferenceTreeGenerator } from './util/preference-tree-generator';
import { PreferencesScopeTabBar } from './views/preference-scope-tabbar-widget';
import { Preference } from './util/preference-types';
import { Event } from '@theia/core/src/common';
export interface PreferenceTreeNodeRow extends TreeWidget.NodeRow {
    visibleChildren: number;
    isExpansible?: boolean;
}
export interface PreferenceTreeNodeProps extends NodeProps {
    visibleChildren: number;
    isExpansible?: boolean;
}
export declare class PreferenceTreeModel extends TreeModelImpl {
    protected readonly schemaProvider: PreferenceSchemaProvider;
    protected readonly filterInput: PreferencesSearchbarWidget;
    protected readonly treeGenerator: PreferenceTreeGenerator;
    protected readonly scopeTracker: PreferencesScopeTabBar;
    protected readonly onTreeFilterChangedEmitter: Emitter<{
        filterCleared: boolean;
        rows: Map<string, PreferenceTreeNodeRow>;
    }>;
    readonly onFilterChanged: Event<{
        filterCleared: boolean;
        rows: Map<string, PreferenceTreeNodeRow>;
    }>;
    protected lastSearchedFuzzy: string;
    protected lastSearchedLiteral: string;
    protected _currentScope: number;
    protected _isFiltered: boolean;
    protected _currentRows: Map<string, PreferenceTreeNodeRow>;
    protected _totalVisibleLeaves: number;
    get currentRows(): Readonly<Map<string, PreferenceTreeNodeRow>>;
    get totalVisibleLeaves(): number;
    get isFiltered(): boolean;
    get propertyList(): {
        [key: string]: PreferenceDataProperty;
    };
    get currentScope(): Preference.SelectedScopeDetails;
    get onSchemaChanged(): Event<CompositeTreeNode>;
    protected init(): void;
    protected updateRows(): void;
    protected updateFilteredRows(filterWasCleared?: boolean): void;
    protected passesCurrentFilters(nodeID: string): boolean;
    protected getDepthForNode(depths: Map<CompositeTreeNode | undefined, number>, node: TreeNode): number;
    protected updateVisibleChildren(node: TreeNode): void;
    collapseAllExcept(openNode: ExpandableTreeNode | undefined): void;
}
//# sourceMappingURL=preference-tree-model.d.ts.map