/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="lodash" />
import { CompositeTreeNode, PreferenceSchemaProvider, SelectableTreeNode } from '@theia/core/lib/browser';
import { PreferenceConfigurations } from '@theia/core/lib/browser/preferences/preference-configurations';
import { Emitter } from '@theia/core';
export declare class PreferenceTreeGenerator {
    protected readonly schemaProvider: PreferenceSchemaProvider;
    protected readonly preferenceConfigs: PreferenceConfigurations;
    protected readonly onSchemaChangedEmitter: Emitter<CompositeTreeNode>;
    readonly onSchemaChanged: import("@theia/core/src/common").Event<CompositeTreeNode>;
    protected init(): Promise<void>;
    generateTree: () => CompositeTreeNode;
    doHandleChangedSchema(): void;
    handleChangedSchema: import("lodash").DebouncedFunc<() => void>;
    protected createRootNode: (preferencesGroups: CompositeTreeNode[]) => CompositeTreeNode;
    protected createLeafNode: (property: string, preferencesGroup: CompositeTreeNode) => SelectableTreeNode;
    protected createPreferencesGroup: (group: string, root: CompositeTreeNode) => CompositeTreeNode;
    protected toTitleCase(nonTitle: string): string;
    protected capitalizeFirst(maybeLowerCase: string): string;
    /**
     * Split based on any non-word character or the 0-length space between a non-upper-case character and an upper-case character
     */
    private split;
    protected formatString(string: string): string;
    protected isUpperCase(char: string): boolean;
}
//# sourceMappingURL=preference-tree-generator.d.ts.map