"use strict";
/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __values = (this && this.__values) || function(o) {
    var s = typeof Symbol === "function" && Symbol.iterator, m = s && o[s], i = 0;
    if (m) return m.call(o);
    if (o && typeof o.length === "number") return {
        next: function () {
            if (o && i >= o.length) o = void 0;
            return { value: o && o[i++], done: !o };
        }
    };
    throw new TypeError(s ? "Object is not iterable." : "Symbol.iterator is not defined.");
};
var __read = (this && this.__read) || function (o, n) {
    var m = typeof Symbol === "function" && o[Symbol.iterator];
    if (!m) return o;
    var i = m.call(o), r, ar = [], e;
    try {
        while ((n === void 0 || n-- > 0) && !(r = i.next()).done) ar.push(r.value);
    }
    catch (error) { e = { error: error }; }
    finally {
        try {
            if (r && !r.done && (m = i["return"])) m.call(i);
        }
        finally { if (e) throw e.error; }
    }
    return ar;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PreferenceTreeGenerator = void 0;
var inversify_1 = require("@theia/core/shared/inversify");
var browser_1 = require("@theia/core/lib/browser");
var preference_configurations_1 = require("@theia/core/lib/browser/preferences/preference-configurations");
var core_1 = require("@theia/core");
var debounce = require("@theia/core/shared/lodash.debounce");
var PreferenceTreeGenerator = /** @class */ (function () {
    function PreferenceTreeGenerator() {
        var _this = this;
        this.onSchemaChangedEmitter = new core_1.Emitter();
        this.onSchemaChanged = this.onSchemaChangedEmitter.event;
        this.generateTree = function () {
            var e_1, _a;
            var preferencesSchema = _this.schemaProvider.getCombinedSchema();
            var propertyNames = Object.keys(preferencesSchema.properties).sort(function (a, b) { return a.localeCompare(b); });
            var preferencesGroups = [];
            var groups = new Map();
            var propertyPattern = Object.keys(preferencesSchema.patternProperties)[0]; // TODO: there may be a better way to get this data.
            var overridePropertyIdentifier = new RegExp(propertyPattern, 'i');
            var root = _this.createRootNode(preferencesGroups);
            try {
                for (var propertyNames_1 = __values(propertyNames), propertyNames_1_1 = propertyNames_1.next(); !propertyNames_1_1.done; propertyNames_1_1 = propertyNames_1.next()) {
                    var propertyName = propertyNames_1_1.value;
                    if (!_this.preferenceConfigs.isSectionName(propertyName) && !overridePropertyIdentifier.test(propertyName)) {
                        var labels = propertyName.split('.');
                        var group = labels[0];
                        var subgroup = labels.length > 2 && labels.slice(0, 2).join('.');
                        if (!groups.has(group)) {
                            var parentPreferencesGroup = _this.createPreferencesGroup(group, root);
                            groups.set(group, parentPreferencesGroup);
                            preferencesGroups.push(parentPreferencesGroup);
                        }
                        if (subgroup && !groups.has(subgroup)) {
                            var remoteParent = groups.get(group);
                            var newBranch = _this.createPreferencesGroup(subgroup, remoteParent);
                            groups.set(subgroup, newBranch);
                            browser_1.CompositeTreeNode.addChild(remoteParent, newBranch);
                        }
                        var parent_1 = groups.get(subgroup || group);
                        var leafNode = _this.createLeafNode(propertyName, parent_1);
                        browser_1.CompositeTreeNode.addChild(parent_1, leafNode);
                    }
                }
            }
            catch (e_1_1) { e_1 = { error: e_1_1 }; }
            finally {
                try {
                    if (propertyNames_1_1 && !propertyNames_1_1.done && (_a = propertyNames_1.return)) _a.call(propertyNames_1);
                }
                finally { if (e_1) throw e_1.error; }
            }
            return root;
        };
        this.handleChangedSchema = debounce(this.doHandleChangedSchema, 200);
        this.createRootNode = function (preferencesGroups) { return ({
            id: 'root-node-id',
            name: '',
            parent: undefined,
            visible: true,
            children: preferencesGroups
        }); };
        this.createLeafNode = function (property, preferencesGroup) {
            var rawLeaf = property.split('.').pop();
            var name = _this.formatString(rawLeaf);
            return {
                id: property,
                name: name,
                parent: preferencesGroup,
                visible: true,
                selected: false,
            };
        };
        this.createPreferencesGroup = function (group, root) {
            var isSubgroup = 'expanded' in root;
            var _a = __read(group.split('.'), 2), groupname = _a[0], subgroupname = _a[1];
            var label = isSubgroup ? subgroupname : groupname;
            var newNode = {
                id: group,
                name: _this.formatString(label),
                visible: true,
                parent: root,
                children: [],
                expanded: false,
                selected: false,
            };
            if (isSubgroup) {
                delete newNode.expanded;
            }
            return newNode;
        };
    }
    PreferenceTreeGenerator.prototype.init = function () {
        return __awaiter(this, void 0, void 0, function () {
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0: return [4 /*yield*/, this.schemaProvider.ready];
                    case 1:
                        _a.sent();
                        this.schemaProvider.onDidPreferenceSchemaChanged(function () { return _this.handleChangedSchema(); });
                        this.handleChangedSchema();
                        return [2 /*return*/];
                }
            });
        });
    };
    PreferenceTreeGenerator.prototype.doHandleChangedSchema = function () {
        this.onSchemaChangedEmitter.fire(this.generateTree());
    };
    PreferenceTreeGenerator.prototype.toTitleCase = function (nonTitle) {
        var _this = this;
        // Any non-word character or the 0-length space between a non-upper-case character and an upper-case character
        return this.split(nonTitle).map(function (word) { return _this.capitalizeFirst(word); }).join(' ').trim();
    };
    PreferenceTreeGenerator.prototype.capitalizeFirst = function (maybeLowerCase) {
        return maybeLowerCase.slice(0, 1).toLocaleUpperCase() + maybeLowerCase.slice(1);
    };
    /**
     * Split based on any non-word character or the 0-length space between a non-upper-case character and an upper-case character
     */
    PreferenceTreeGenerator.prototype.split = function (string) {
        var split = [];
        var regex = /[A-Z]+[a-z0-9]*|[A-Z]*[a-z0-9]+/g;
        // eslint-disable-next-line no-null/no-null
        var match;
        while ((match = regex.exec(string)) !== null) {
            split.push(match[0]);
        }
        return split;
    };
    PreferenceTreeGenerator.prototype.formatString = function (string) {
        var formatedString = string[0].toLocaleUpperCase();
        for (var i = 1; i < string.length; i++) {
            if (this.isUpperCase(string[i]) && !/\s/.test(string[i - 1]) && !this.isUpperCase(string[i - 1])) {
                formatedString += ' ';
            }
            formatedString += string[i];
        }
        return formatedString.trim();
    };
    PreferenceTreeGenerator.prototype.isUpperCase = function (char) {
        return char === char.toLocaleUpperCase() && char.toLocaleLowerCase() !== char.toLocaleUpperCase();
    };
    __decorate([
        inversify_1.inject(browser_1.PreferenceSchemaProvider),
        __metadata("design:type", browser_1.PreferenceSchemaProvider)
    ], PreferenceTreeGenerator.prototype, "schemaProvider", void 0);
    __decorate([
        inversify_1.inject(preference_configurations_1.PreferenceConfigurations),
        __metadata("design:type", preference_configurations_1.PreferenceConfigurations)
    ], PreferenceTreeGenerator.prototype, "preferenceConfigs", void 0);
    __decorate([
        inversify_1.postConstruct(),
        __metadata("design:type", Function),
        __metadata("design:paramtypes", []),
        __metadata("design:returntype", Promise)
    ], PreferenceTreeGenerator.prototype, "init", null);
    PreferenceTreeGenerator = __decorate([
        inversify_1.injectable()
    ], PreferenceTreeGenerator);
    return PreferenceTreeGenerator;
}());
exports.PreferenceTreeGenerator = PreferenceTreeGenerator;
//# sourceMappingURL=preference-tree-generator.js.map