/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
/// <reference types="lodash" />
import { ReactWidget, StatefulWidget } from '@theia/core/lib/browser';
import * as React from '@theia/core/shared/react';
import { Emitter } from '@theia/core';
export interface PreferencesSearchbarState {
    searchTerm: string;
}
export declare class PreferencesSearchbarWidget extends ReactWidget implements StatefulWidget {
    static readonly ID = "settings.header";
    static readonly LABEL = "Settings Header";
    static readonly SEARCHBAR_ID = "preference-searchbar";
    protected readonly onFilterStringChangedEmitter: Emitter<string>;
    readonly onFilterChanged: import("@theia/core/src/common").Event<string>;
    protected searchbarRef: React.RefObject<HTMLInputElement>;
    protected resultsCount: number;
    protected init(): void;
    protected handleSearch: (e: React.ChangeEvent<HTMLInputElement>) => void;
    protected search: import("lodash").DebouncedFunc<(value: string) => void>;
    focus(): void;
    /**
     * Clears the search input and all search results.
     * @param e on-click mouse event.
     */
    protected clearSearchResults: (e: React.MouseEvent) => void;
    /**
     * Renders all search bar options.
     */
    protected renderOptionContainer(): React.ReactNode;
    /**
     * Renders a badge displaying search results count.
     */
    protected renderResultsCountOption(): React.ReactNode;
    /**
     * Renders a clear all button.
     */
    protected renderClearAllOption(): React.ReactNode;
    /**
     * Determines whether the search input currently has a value.
     * @returns true, if the search input currently has a value; false, otherwise.
     */
    protected searchTermExists(): boolean;
    protected getSearchTerm(): string;
    protected updateSearchTerm(searchTerm: string): void;
    render(): React.ReactNode;
    /**
     * Updates the search result count.
     * @param count the result count.
     */
    updateResultsCount(count: number): void;
    storeState(): PreferencesSearchbarState;
    restoreState(oldState: PreferencesSearchbarState): void;
}
//# sourceMappingURL=preference-searchbar-widget.d.ts.map