/********************************************************************************
 * Copyright (C) 2020 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
/// <reference types="react" />
import { ContextMenuRenderer, PreferenceService, TreeNode, TreeProps, TreeWidget } from '@theia/core/lib/browser';
import { PreferenceConfigurations } from '@theia/core/lib/browser/preferences/preference-configurations';
import React = require('@theia/core/shared/react');
import { PreferenceTreeModel, PreferenceTreeNodeRow, PreferenceTreeNodeProps } from '../preference-tree-model';
export declare class PreferencesTreeWidget extends TreeWidget {
    static ID: string;
    protected shouldFireSelectionEvents: boolean;
    protected firstVisibleLeafNodeID: string;
    protected readonly preferenceService: PreferenceService;
    protected readonly preferenceConfigs: PreferenceConfigurations;
    readonly model: PreferenceTreeModel;
    protected readonly treeProps: TreeProps;
    protected readonly contextMenuRenderer: ContextMenuRenderer;
    init(): void;
    doUpdateRows(): void;
    protected doRenderNodeRow({ depth, visibleChildren, node, isExpansible }: PreferenceTreeNodeRow): React.ReactNode;
    protected renderNode(node: TreeNode, props: PreferenceTreeNodeProps): React.ReactNode;
    protected renderExpansionToggle(node: TreeNode, props: PreferenceTreeNodeProps): React.ReactNode;
}
//# sourceMappingURL=preference-tree-widget.d.ts.map