/********************************************************************************
 * Copyright (C) 2020 Alibaba Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { IPty } from '@theia/node-pty';
import { Event } from '@theia/core';
export declare class PseudoPty implements IPty {
    readonly pid: number;
    readonly cols: number;
    readonly rows: number;
    readonly process: string;
    handleFlowControl: boolean;
    readonly onData: Event<string>;
    readonly onExit: Event<{
        exitCode: number;
        signal?: number;
    }>;
    on(event: string, listener: (data: string) => void): void;
    on(event: string, listener: (exitCode: number, signal?: number) => void): void;
    on(event: string, listener: (error?: string) => void): void;
    resize(columns: number, rows: number): void;
    write(data: string): void;
    kill(signal?: string): void;
}
//# sourceMappingURL=pseudo-pty.d.ts.map