/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { PropertyViewWidgetProvider } from './property-view-widget-provider';
/**
 * `PropertyViewService` provides an access to existing property view widget providers.
 */
export declare class PropertyViewService {
    private readonly contributions;
    private readonly emptyWidgetProvider;
    private providers;
    init(): void;
    /**
     * Return a property view widget provider with the highest priority for the given selection.
     * Never reject, return DefaultProvider ('No properties available') if no other matches.
     */
    getProvider(selection: Object | undefined): Promise<PropertyViewWidgetProvider>;
    protected prioritize(selection: Object | undefined): Promise<PropertyViewWidgetProvider | undefined>;
}
//# sourceMappingURL=property-view-service.d.ts.map