/********************************************************************************
 * Copyright (C) 2020 EclipseSource and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
import { CompositeTreeNode, ExpandableTreeNode, SelectableTreeNode, TreeNode } from '@theia/core/lib/browser';
export declare const ROOT_ID = "ResourcePropertiesTree";
export interface ResourcePropertiesRoot extends CompositeTreeNode {
    children: ResourcePropertiesCategoryNode[];
}
export declare namespace ResourcePropertiesRoot {
    function is(node: Object | undefined): node is ResourcePropertiesRoot;
}
export interface ResourcePropertiesCategoryNode extends ExpandableTreeNode, SelectableTreeNode {
    name: string;
    icon?: string;
    children: ResourcePropertiesItemNode[];
    parent: ResourcePropertiesRoot;
    categoryId: string;
}
export declare namespace ResourcePropertiesCategoryNode {
    function is(node: TreeNode | undefined): node is ResourcePropertiesCategoryNode;
}
export interface ResourcePropertiesItemNode extends SelectableTreeNode {
    name: string;
    icon?: string;
    parent: ResourcePropertiesCategoryNode;
    property: string;
}
export declare namespace ResourcePropertiesItemNode {
    function is(node: TreeNode | undefined): node is ResourcePropertiesItemNode;
}
//# sourceMappingURL=resource-property-view-tree-items.d.ts.map