"use strict";
/********************************************************************************
 * Copyright (C) 2018 Red Hat, Inc. and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProcessTaskError = exports.ProcessTaskInfo = void 0;
var application_error_1 = require("@theia/core/lib/common/application-error");
var ProcessTaskInfo;
(function (ProcessTaskInfo) {
    function is(info) {
        return info['processId'] !== undefined;
    }
    ProcessTaskInfo.is = is;
})(ProcessTaskInfo = exports.ProcessTaskInfo || (exports.ProcessTaskInfo = {}));
var ProcessTaskError;
(function (ProcessTaskError) {
    ProcessTaskError.CouldNotRun = application_error_1.ApplicationError.declare(1, function (code) { return ({
        message: "Error starting process (" + code + ")",
        data: { code: code }
    }); });
})(ProcessTaskError = exports.ProcessTaskError || (exports.ProcessTaskError = {}));
//# sourceMappingURL=task-protocol.js.map