"use strict";
/********************************************************************************
 * Copyright (C) 2018 Ericsson and others.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the Eclipse
 * Public License v. 2.0 are satisfied: GNU General Public License, version 2
 * with the GNU Classpath Exception which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 ********************************************************************************/
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCommonBindings = void 0;
var core_1 = require("@theia/core");
var task_watcher_1 = require("./task-watcher");
/**
 * Create the bindings common to node and browser.
 *
 * @param bind The bind function from inversify.
 */
function createCommonBindings(bind) {
    bind(core_1.ILogger).toDynamicValue(function (ctx) {
        var logger = ctx.container.get(core_1.ILogger);
        return logger.child('task');
    }).inSingletonScope().whenTargetNamed('task');
    bind(task_watcher_1.TaskWatcher).toSelf().inSingletonScope();
}
exports.createCommonBindings = createCommonBindings;
//# sourceMappingURL=task-common-module.js.map